/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.providers.luckperms;

import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.model.user.User;
import net.luckperms.api.query.QueryOptions;
import net.thenextlvl.service.api.DoNotWrap;
import net.thenextlvl.service.api.chat.ChatController;
import net.thenextlvl.service.api.chat.ChatProfile;
import net.thenextlvl.service.providers.luckperms.LuckPermsChatProfile;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.NullMarked;

@DoNotWrap
@NullMarked
public class LuckPermsChatController
implements ChatController {
    private final LuckPerms luckPerms = LuckPermsProvider.get();
    private final Plugin plugin;

    public LuckPermsChatController(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public CompletableFuture<ChatProfile> loadProfile(UUID uuid) {
        return this.luckPerms.getUserManager().loadUser(uuid).thenApply(user -> new LuckPermsChatProfile((User)user, QueryOptions.defaultContextualOptions()));
    }

    @Override
    public CompletableFuture<ChatProfile> loadProfile(UUID uuid, World world) {
        return this.luckPerms.getUserManager().loadUser(uuid).thenApply(user -> {
            QueryOptions options = QueryOptions.contextual((ContextSet)ImmutableContextSet.of((String)"world", (String)world.getName()));
            return new LuckPermsChatProfile((User)user, options);
        });
    }

    @Override
    public Optional<ChatProfile> getProfile(UUID uuid) {
        return Optional.ofNullable(this.luckPerms.getUserManager().getUser(uuid)).map(user -> new LuckPermsChatProfile((User)user, QueryOptions.defaultContextualOptions()));
    }

    @Override
    public Optional<ChatProfile> getProfile(UUID uuid, World world) {
        return Optional.ofNullable(this.luckPerms.getUserManager().getUser(uuid)).map(user -> {
            QueryOptions options = QueryOptions.contextual((ContextSet)ImmutableContextSet.of((String)"world", (String)world.getName()));
            return new LuckPermsChatProfile((User)user, options);
        });
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public String getName() {
        return "LuckPerms Chat";
    }
}

