/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.providers.groupmanager;

import java.util.HashSet;
import java.util.Optional;
import net.milkbowl.vault.permission.Permission;
import net.thenextlvl.service.api.DoNotWrap;
import org.anjocaido.groupmanager.GroupManager;
import org.anjocaido.groupmanager.data.Group;
import org.anjocaido.groupmanager.data.User;
import org.anjocaido.groupmanager.dataholder.OverloadedWorldHolder;
import org.anjocaido.groupmanager.dataholder.worlds.WorldsHolder;
import org.anjocaido.groupmanager.permissions.AnjoPermissionsHandler;
import org.bukkit.World;
import org.bukkit.plugin.java.JavaPlugin;
import org.jspecify.annotations.Nullable;

@DoNotWrap
public class GroupManagerPermission
extends Permission {
    private final GroupManager groupManager = (GroupManager)JavaPlugin.getPlugin(GroupManager.class);

    public GroupManagerPermission() {
        this.plugin = this.groupManager;
    }

    @Override
    public String getName() {
        return "GroupManager";
    }

    @Override
    public boolean isEnabled() {
        return this.groupManager.isEnabled();
    }

    @Override
    public boolean hasSuperPermsCompat() {
        return true;
    }

    @Override
    public boolean playerHas(@Nullable String world, String player, String permission) {
        return this.getWorldHolder(player, world).map(handler -> handler.permission(player, permission)).orElse(false);
    }

    @Override
    public boolean playerAdd(@Nullable String world, String player, String permission) {
        return this.getWorldHolder(world).flatMap(holder -> this.getUser((OverloadedWorldHolder)holder, player).map(user -> {
            user.addPermission(permission);
            return true;
        })).orElse(false);
    }

    @Override
    public boolean playerRemove(@Nullable String world, String player, String permission) {
        return this.getWorldHolder(world).flatMap(holder -> this.getUser((OverloadedWorldHolder)holder, player).map(user -> user.removePermission(permission))).orElse(false);
    }

    @Override
    public boolean groupHas(@Nullable String world, String group, String permission) {
        return this.getWorldHolder(world).flatMap(holder -> this.getGroup((OverloadedWorldHolder)holder, group).map(g -> g.hasSamePermissionNode(permission))).orElse(false);
    }

    @Override
    public boolean groupAdd(@Nullable String world, String group, String permission) {
        return this.getWorldHolder(world).flatMap(holder -> this.getGroup((OverloadedWorldHolder)holder, group).map(g -> {
            g.addPermission(permission);
            return true;
        })).orElse(false);
    }

    @Override
    public boolean groupRemove(@Nullable String world, String group, String permission) {
        return this.getWorldHolder(world).flatMap(holder -> this.getGroup((OverloadedWorldHolder)holder, group).map(g -> {
            g.removePermission(permission);
            return true;
        })).orElse(false);
    }

    @Override
    public boolean playerInGroup(@Nullable String world, String player, String group) {
        return this.getWorldHolder(player, world).map(handler -> handler.inGroup(player, group)).orElse(false);
    }

    @Override
    public boolean playerAddGroup(@Nullable String world, String player, String group) {
        return this.getWorldHolder(world).flatMap(holder -> this.getUser((OverloadedWorldHolder)holder, player).flatMap(user -> this.getGroup((OverloadedWorldHolder)holder, group).map(arg_0 -> ((User)user).addSubGroup(arg_0)))).orElse(false);
    }

    @Override
    public boolean playerRemoveGroup(@Nullable String world, String player, String group) {
        return this.getWorldHolder(world).flatMap(holder -> this.getUser((OverloadedWorldHolder)holder, player).flatMap(user -> this.getGroup((OverloadedWorldHolder)holder, group).map(arg_0 -> ((User)user).removeSubGroup(arg_0)))).orElse(false);
    }

    @Override
    public String[] getPlayerGroups(@Nullable String world, String player) {
        return this.getWorldHolder(player, world).map(handler -> handler.getGroups(player)).orElse(new String[0]);
    }

    @Override
    public String getPrimaryGroup(@Nullable String world, String player) {
        return this.getWorldHolder(player, world).map(handler -> handler.getGroup(player)).orElse(null);
    }

    @Override
    public String[] getGroups() {
        HashSet groups = new HashSet();
        for (World world : this.groupManager.getServer().getWorlds()) {
            OverloadedWorldHolder holder = this.groupManager.getWorldsHolder().getWorldData(world.getName());
            if (holder == null) continue;
            holder.getGroupList().forEach(group -> groups.add(group.getName()));
        }
        return groups.toArray(new String[0]);
    }

    private Optional<Group> getGroup(OverloadedWorldHolder holder, String name) {
        return Optional.ofNullable(holder.getGroup(name));
    }

    private Optional<User> getUser(OverloadedWorldHolder holder, String name) {
        return Optional.ofNullable(holder.getUser(name));
    }

    private Optional<OverloadedWorldHolder> getWorldHolder(@Nullable String world) {
        return Optional.ofNullable(world).map(arg_0 -> ((WorldsHolder)this.groupManager.getWorldsHolder()).getWorldData(arg_0)).or(() -> Optional.ofNullable(this.groupManager.getWorldsHolder().getDefaultWorld()));
    }

    private Optional<AnjoPermissionsHandler> getWorldHolder(String player, @Nullable String world) {
        if (world != null) {
            return Optional.ofNullable(this.groupManager.getWorldsHolder().getWorldPermissions(world));
        }
        return Optional.ofNullable(this.groupManager.getWorldsHolder().getWorldPermissionsByPlayerName(player));
    }

    private Optional<OverloadedWorldHolder> getWorldDataHolder(String player, @Nullable String world) {
        if (world != null) {
            return Optional.ofNullable(this.groupManager.getWorldsHolder().getWorldData(world));
        }
        return Optional.ofNullable(this.groupManager.getWorldsHolder().getWorldDataByPlayerName(player));
    }

    @Override
    public boolean hasGroupSupport() {
        return true;
    }
}

