/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.providers.groupmanager;

import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.thenextlvl.service.api.group.GroupController;
import net.thenextlvl.service.api.group.GroupHolder;
import net.thenextlvl.service.providers.groupmanager.GroupManagerGroup;
import net.thenextlvl.service.providers.groupmanager.GroupManagerPermissionHolder;
import org.anjocaido.groupmanager.GroupManager;
import org.anjocaido.groupmanager.data.Group;
import org.anjocaido.groupmanager.data.User;
import org.anjocaido.groupmanager.dataholder.OverloadedWorldHolder;
import org.anjocaido.groupmanager.dataholder.WorldDataHolder;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class GroupManagerGroupController
implements GroupController {
    private final GroupManager groupManager = (GroupManager)JavaPlugin.getPlugin(GroupManager.class);

    @Override
    public CompletableFuture<net.thenextlvl.service.api.group.Group> createGroup(String name) {
        Group group = GroupManager.getGlobalGroups().newGroup(new Group(name));
        if (group != null) {
            return CompletableFuture.completedFuture(new GroupManagerGroup(group));
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<net.thenextlvl.service.api.group.Group> createGroup(String name, World world) {
        OverloadedWorldHolder holder = this.groupManager.getWorldsHolder().getWorldData(world.getName());
        if (holder == null) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.completedFuture(new GroupManagerGroup(holder.createGroup(name)));
    }

    @Override
    public CompletableFuture<net.thenextlvl.service.api.group.Group> loadGroup(String name) {
        return CompletableFuture.completedFuture(this.getGroup(name).orElse(null));
    }

    @Override
    public CompletableFuture<net.thenextlvl.service.api.group.Group> loadGroup(String name, World world) {
        return CompletableFuture.completedFuture(this.getGroup(name, world).orElse(null));
    }

    @Override
    public CompletableFuture<GroupHolder> loadGroupHolder(OfflinePlayer player) {
        return CompletableFuture.completedFuture(this.getGroupHolder(player).orElse(null));
    }

    @Override
    public CompletableFuture<GroupHolder> loadGroupHolder(OfflinePlayer player, World world) {
        return CompletableFuture.completedFuture(this.getGroupHolder(player, world).orElse(null));
    }

    @Override
    public CompletableFuture<GroupHolder> loadGroupHolder(UUID uuid) {
        return CompletableFuture.completedFuture(this.getGroupHolder(uuid).orElse(null));
    }

    @Override
    public CompletableFuture<GroupHolder> loadGroupHolder(UUID uuid, World world) {
        return CompletableFuture.completedFuture(this.getGroupHolder(uuid, world).orElse(null));
    }

    @Override
    public CompletableFuture<Set<net.thenextlvl.service.api.group.Group>> loadGroups() {
        return CompletableFuture.completedFuture(this.getGroups());
    }

    @Override
    public CompletableFuture<Set<net.thenextlvl.service.api.group.Group>> loadGroups(World world) {
        return CompletableFuture.completedFuture(this.getGroups(world));
    }

    @Override
    public CompletableFuture<Boolean> deleteGroup(net.thenextlvl.service.api.group.Group group) {
        return this.deleteGroup(group.getName());
    }

    @Override
    public CompletableFuture<Boolean> deleteGroup(net.thenextlvl.service.api.group.Group group, World world) {
        return this.deleteGroup(group.getName(), world);
    }

    @Override
    public CompletableFuture<Boolean> deleteGroup(String name) {
        return CompletableFuture.completedFuture(GroupManager.getGlobalGroups().removeGroup(name));
    }

    @Override
    public CompletableFuture<Boolean> deleteGroup(String name, World world) {
        OverloadedWorldHolder holder = this.groupManager.getWorldsHolder().getWorldData(world.getName());
        if (holder != null) {
            CompletableFuture.completedFuture(holder.removeGroup(name));
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public Optional<net.thenextlvl.service.api.group.Group> getGroup(String name) {
        return Optional.ofNullable(GroupManager.getGlobalGroups().getGroup(name)).map(GroupManagerGroup::new);
    }

    @Override
    public Optional<net.thenextlvl.service.api.group.Group> getGroup(String name, World world) {
        OverloadedWorldHolder holder = this.groupManager.getWorldsHolder().getWorldData(world.getName());
        return Optional.ofNullable(holder).map(holder1 -> holder1.getGroup(name)).map(GroupManagerGroup::new);
    }

    @Override
    public Optional<GroupHolder> getGroupHolder(OfflinePlayer player) {
        OverloadedWorldHolder holder = this.groupManager.getWorldsHolder().getDefaultWorld();
        return this.getHolder((WorldDataHolder)holder, player.getUniqueId(), player.getName());
    }

    @Override
    public Optional<GroupHolder> getGroupHolder(OfflinePlayer player, World world) {
        OverloadedWorldHolder holder = this.groupManager.getWorldsHolder().getWorldData(world.getName());
        return this.getHolder((WorldDataHolder)holder, player.getUniqueId(), player.getName());
    }

    @Override
    public Optional<GroupHolder> getGroupHolder(UUID uuid) {
        OverloadedWorldHolder holder = this.groupManager.getWorldsHolder().getDefaultWorld();
        return this.getHolder((WorldDataHolder)holder, uuid, null);
    }

    @Override
    public Optional<GroupHolder> getGroupHolder(UUID uuid, World world) {
        OverloadedWorldHolder holder = this.groupManager.getWorldsHolder().getWorldData(world.getName());
        return this.getHolder((WorldDataHolder)holder, uuid, null);
    }

    @Override
    public Set<net.thenextlvl.service.api.group.Group> getGroups() {
        return this.groupManager.getServer().getWorlds().stream().mapMulti((world, consumer) -> this.getGroups((World)world).forEach(consumer)).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Set<net.thenextlvl.service.api.group.Group> getGroups(World world) {
        OverloadedWorldHolder holder = this.groupManager.getWorldsHolder().getWorldData(world.getName());
        if (holder == null) {
            return Set.of();
        }
        return holder.getGroups().values().stream().map(GroupManagerGroup::new).collect(Collectors.toUnmodifiableSet());
    }

    private Optional<GroupHolder> getHolder(@Nullable WorldDataHolder holder, UUID uuid, @Nullable String name) {
        User user;
        if (holder == null) {
            return Optional.empty();
        }
        User user2 = user = name != null ? holder.getUser(uuid.toString(), name) : holder.getUser(uuid.toString());
        if (user == null) {
            return Optional.empty();
        }
        return Optional.of(new GroupManagerPermissionHolder(user, holder));
    }

    @Override
    public Plugin getPlugin() {
        return this.groupManager;
    }

    @Override
    public String getName() {
        return "GroupManager Groups";
    }
}

