/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.providers.groupmanager;

import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kyori.adventure.util.TriState;
import org.anjocaido.groupmanager.GroupManager;
import org.anjocaido.groupmanager.data.Group;
import org.anjocaido.groupmanager.permissions.AnjoPermissionsHandler;
import org.anjocaido.groupmanager.utils.PermissionCheckResult;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public record GroupManagerGroup(Group group) implements net.thenextlvl.service.api.group.Group
{
    @Override
    public Optional<String> getDisplayName() {
        return Optional.empty();
    }

    @Override
    public Optional<String> getPrefix(int priority) {
        return this.getInfoNode("prefix");
    }

    @Override
    public @Unmodifiable Map<Integer, String> getPrefixes() {
        return this.getPrefix().map(prefix -> Map.of(0, prefix)).orElseGet(Map::of);
    }

    @Override
    public Optional<String> getSuffix(int priority) {
        return this.getInfoNode("suffix");
    }

    @Override
    public @Unmodifiable Map<Integer, String> getSuffixes() {
        return this.getSuffix().map(suffix -> Map.of(0, suffix)).orElseGet(Map::of);
    }

    @Override
    public OptionalInt getWeight() {
        return OptionalInt.empty();
    }

    @Override
    public String getName() {
        return this.group().getName();
    }

    @Override
    public Optional<World> getWorld() {
        GroupManager plugin = (GroupManager)JavaPlugin.getPlugin(GroupManager.class);
        return Optional.ofNullable(this.group().getDataSource().getName()).map(arg_0 -> ((Server)plugin.getServer()).getWorld(arg_0));
    }

    @Override
    public boolean setDisplayName(@Nullable String displayName) {
        return false;
    }

    @Override
    public boolean setWeight(int weight) {
        return false;
    }

    @Override
    public boolean setPrefix(@Nullable String prefix, int priority) {
        return this.setInfoNode("prefix", prefix);
    }

    @Override
    public boolean setSuffix(@Nullable String suffix, int priority) {
        return this.setInfoNode("suffix", suffix);
    }

    @Override
    public @Unmodifiable Map<String, Boolean> getPermissions() {
        return this.group.getPermissionList().stream().collect(Collectors.toUnmodifiableMap(permission -> permission, permission -> this.checkPermission((String)permission).toBooleanOrElse(false)));
    }

    @Override
    public TriState checkPermission(String permission) {
        AnjoPermissionsHandler handler = this.group().getDataSource().getPermissionsHandler();
        return switch (handler.checkGroupOnlyPermission((Group)this.group(), (String)permission).resultType) {
            case PermissionCheckResult.Type.FOUND -> TriState.TRUE;
            case PermissionCheckResult.Type.NEGATION, PermissionCheckResult.Type.EXCEPTION -> TriState.FALSE;
            default -> TriState.NOT_SET;
        };
    }

    @Override
    public boolean addPermission(String permission) {
        return this.setPermission(permission, true);
    }

    @Override
    public boolean removePermission(String permission) {
        return this.group().removePermission(permission);
    }

    @Override
    public boolean setPermission(String permission, boolean value) {
        Boolean state = this.checkPermission(permission).toBoolean();
        if (state != null && state.equals(value)) {
            return false;
        }
        this.removePermission((String)(value ? "-" + permission : permission));
        this.group().addPermission((String)(!value ? "-" + permission : permission));
        return true;
    }

    @Override
    public <T> Optional<T> getInfoNode(String key, Function<@Nullable String, @Nullable T> mapper) {
        return Optional.ofNullable(mapper.apply(this.group().getVariables().getVarString(key)));
    }

    @Override
    public boolean removeInfoNode(String key) {
        if (!this.hasInfoNode(key)) {
            return false;
        }
        this.group().getVariables().removeVar(key);
        return true;
    }

    @Override
    public boolean setInfoNode(String key, @Nullable String value) {
        this.group().getVariables().addVar(key, (Object)value);
        return true;
    }

    @Override
    public boolean hasInfoNode(String key) {
        return this.group().getVariables().hasVar(key);
    }
}

