/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.providers.fancyholograms.v2;

import de.oliver.fancyholograms.api.FancyHologramsPlugin;
import de.oliver.fancyholograms.api.data.BlockHologramData;
import de.oliver.fancyholograms.api.data.ItemHologramData;
import de.oliver.fancyholograms.api.data.TextHologramData;
import de.oliver.fancyholograms.api.data.property.Visibility;
import de.oliver.fancyholograms.api.hologram.HologramType;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.thenextlvl.service.api.capability.CapabilityException;
import net.thenextlvl.service.api.hologram.Hologram;
import net.thenextlvl.service.api.hologram.HologramCapability;
import net.thenextlvl.service.api.hologram.HologramLine;
import net.thenextlvl.service.providers.fancyholograms.v2.FancyBlockHologramLine;
import net.thenextlvl.service.providers.fancyholograms.v2.FancyItemHologramLine;
import net.thenextlvl.service.providers.fancyholograms.v2.FancyTextHologramLine;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public record FancyHologram(de.oliver.fancyholograms.api.hologram.Hologram hologram) implements Hologram
{
    @Override
    public CompletableFuture<Boolean> teleportAsync(Location location) {
        this.hologram().getData().setLocation(location);
        this.hologram().refreshForViewersInWorld();
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public @Unmodifiable List<HologramLine<?>> getLines() {
        return List.of(switch (this.hologram().getData().getType()) {
            default -> throw new MatchException(null, null);
            case HologramType.BLOCK -> new FancyBlockHologramLine((BlockHologramData)this.hologram().getData());
            case HologramType.ITEM -> new FancyItemHologramLine((ItemHologramData)this.hologram().getData());
            case HologramType.TEXT -> new FancyTextHologramLine((TextHologramData)this.hologram().getData());
        });
    }

    @Override
    public boolean addLine(HologramLine<?> line) throws CapabilityException {
        throw new CapabilityException("FancyHolograms does not support multiline holograms", HologramCapability.MULTILINE);
    }

    @Override
    public boolean addLine(int index, HologramLine<?> line) throws CapabilityException {
        throw new CapabilityException("FancyHolograms does not support multiline holograms", HologramCapability.MULTILINE);
    }

    @Override
    public boolean addLines(Collection<HologramLine<?>> lines) throws CapabilityException {
        throw new CapabilityException("FancyHolograms does not support multiline holograms", HologramCapability.MULTILINE);
    }

    @Override
    public boolean removeLine(HologramLine<?> line) throws CapabilityException {
        throw new CapabilityException("FancyHolograms does not support multiline holograms", HologramCapability.MULTILINE);
    }

    @Override
    public boolean removeLine(int index) throws CapabilityException {
        throw new CapabilityException("FancyHolograms does not support multiline holograms", HologramCapability.MULTILINE);
    }

    @Override
    public int getLineCount() {
        return 1;
    }

    @Override
    public void remove() {
        FancyHologramsPlugin.get().getHologramManager().removeHologram(this.hologram());
    }

    @Override
    public Iterator<HologramLine<?>> iterator() {
        return this.getLines().iterator();
    }

    @Override
    public String getName() {
        return this.hologram().getName();
    }

    @Override
    public boolean isPersistent() {
        return this.hologram().getData().isPersistent();
    }

    @Override
    public boolean persist() {
        if (!this.isPersistent()) {
            return false;
        }
        FancyHologramsPlugin.get().getHologramManager().saveHolograms();
        return true;
    }

    @Override
    public void setPersistent(boolean persistent) {
        this.hologram().getData().setPersistent(true);
    }

    @Override
    public @Unmodifiable Set<Player> getTrackedBy() {
        return this.hologram().getViewers().stream().map(arg_0 -> ((Server)this.getServer()).getPlayer(arg_0)).filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public @Unmodifiable Set<Player> getViewers() {
        return this.getServer().getOnlinePlayers().stream().filter(this::canSee).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public boolean addViewer(Player player) {
        this.hologram().showHologram(player);
        return this.canSee(player);
    }

    @Override
    public boolean addViewers(Collection<Player> players) {
        return players.stream().map(this::addViewer).reduce(false, Boolean::logicalOr);
    }

    @Override
    public boolean isTrackedBy(Player player) {
        return this.hologram().isViewer(player);
    }

    @Override
    public boolean canSee(Player player) {
        return this.hologram().meetsVisibilityConditions(player);
    }

    @Override
    public boolean isVisibleByDefault() {
        return this.hologram().getData().getVisibility().equals((Object)Visibility.ALL);
    }

    @Override
    public boolean removeViewer(Player player) {
        this.hologram().hideHologram(player);
        this.hologram().forceHideHologram(player);
        return this.canSee(player);
    }

    @Override
    public boolean removeViewers(Collection<Player> players) {
        return players.stream().map(this::removeViewer).reduce(false, Boolean::logicalOr);
    }

    @Override
    public double getDisplayRange() {
        return this.hologram().getData().getVisibilityDistance();
    }

    @Override
    public void setDisplayRange(double range) {
        this.hologram().getData().setVisibilityDistance((int)range);
    }

    @Override
    public void setVisibleByDefault(boolean visible) {
        this.hologram().getData().setVisibility(visible ? Visibility.ALL : Visibility.MANUAL);
    }

    @Override
    public Location getLocation() {
        return this.hologram().getData().getLocation();
    }

    @Override
    public Server getServer() {
        return Bukkit.getServer();
    }

    @Override
    public World getWorld() {
        return this.getLocation().getWorld();
    }

    @Override
    public double getX() {
        return this.getLocation().getX();
    }

    @Override
    public double getY() {
        return this.getLocation().getY();
    }

    @Override
    public double getZ() {
        return this.getLocation().getZ();
    }

    @Override
    public float getPitch() {
        return this.getLocation().getPitch();
    }

    @Override
    public float getYaw() {
        return this.getLocation().getYaw();
    }
}

