/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.providers.decentholograms;

import eu.decentsoftware.holograms.api.DHAPI;
import eu.decentsoftware.holograms.api.holograms.Hologram;
import eu.decentsoftware.holograms.api.holograms.HologramLine;
import eu.decentsoftware.holograms.api.holograms.enums.HologramLineType;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.thenextlvl.service.providers.decentholograms.DecentBlockHologramLine;
import net.thenextlvl.service.providers.decentholograms.DecentEntityHologramLine;
import net.thenextlvl.service.providers.decentholograms.DecentHologramLine;
import net.thenextlvl.service.providers.decentholograms.DecentItemHologramLine;
import net.thenextlvl.service.providers.decentholograms.DecentTextHologramLine;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public record DecentHologram(Hologram hologram) implements net.thenextlvl.service.api.hologram.Hologram
{
    @Override
    public CompletableFuture<Boolean> teleportAsync(Location location) {
        DHAPI.moveHologram((Hologram)this.hologram(), (Location)location);
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public @Unmodifiable List<net.thenextlvl.service.api.hologram.HologramLine<?>> getLines() {
        return this.hologram().getPage(0).getLines().stream().map(line -> switch (line.getType()) {
            default -> throw new MatchException(null, null);
            case HologramLineType.TEXT -> new DecentTextHologramLine((HologramLine)line);
            case HologramLineType.HEAD -> new DecentBlockHologramLine((HologramLine)line, false);
            case HologramLineType.SMALLHEAD -> new DecentBlockHologramLine((HologramLine)line, true);
            case HologramLineType.ENTITY -> new DecentEntityHologramLine((HologramLine)line);
            case HologramLineType.ICON -> new DecentItemHologramLine((HologramLine)line);
            case HologramLineType.UNKNOWN -> throw new IllegalStateException("Unknown line type: " + String.valueOf(line));
        }).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public boolean addLine(net.thenextlvl.service.api.hologram.HologramLine<?> line) {
        if (!(line instanceof DecentHologramLine)) {
            return false;
        }
        DecentHologramLine decentLine = (DecentHologramLine)line;
        line.getLocation().setWorld(this.getWorld());
        return this.hologram().getPage(0).addLine(decentLine.line);
    }

    @Override
    public boolean addLine(int index, net.thenextlvl.service.api.hologram.HologramLine<?> line) {
        if (!(line instanceof DecentHologramLine)) {
            return false;
        }
        DecentHologramLine decentLine = (DecentHologramLine)line;
        return this.hologram().getPage(0).insertLine(index, decentLine.line);
    }

    @Override
    public boolean addLines(Collection<net.thenextlvl.service.api.hologram.HologramLine<?>> lines) {
        return lines.stream().map(this::addLine).reduce(false, Boolean::logicalOr);
    }

    @Override
    public boolean removeLine(net.thenextlvl.service.api.hologram.HologramLine<?> line) {
        int index = this.getLines().indexOf(line);
        return index >= 0 && this.removeLine(index);
    }

    @Override
    public boolean removeLine(int index) {
        return this.hologram().getPage(0).removeLine(0) != null;
    }

    @Override
    public int getLineCount() {
        return this.hologram().getPage(0).size();
    }

    @Override
    public void remove() {
        this.hologram().delete();
    }

    @Override
    public Iterator<net.thenextlvl.service.api.hologram.HologramLine<?>> iterator() {
        return this.getLines().iterator();
    }

    @Override
    public String getName() {
        return this.hologram().getName();
    }

    @Override
    public boolean isPersistent() {
        return this.hologram().isSaveToFile();
    }

    @Override
    public boolean persist() {
        if (!this.isPersistent()) {
            return false;
        }
        this.hologram().save();
        return true;
    }

    @Override
    public void setPersistent(boolean persistent) {
        this.hologram().setSaveToFile(persistent);
    }

    @Override
    public Location getLocation() {
        return this.hologram().getLocation();
    }

    @Override
    public Server getServer() {
        return Bukkit.getServer();
    }

    @Override
    public @Unmodifiable Set<Player> getTrackedBy() {
        return this.hologram().getViewers().stream().map(arg_0 -> ((Server)this.getServer()).getPlayer(arg_0)).filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public @Unmodifiable Set<Player> getViewers() {
        return this.hologram().getShowPlayers().stream().map(arg_0 -> ((Server)this.getServer()).getPlayer(arg_0)).filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public World getWorld() {
        return this.getLocation().getWorld();
    }

    @Override
    public boolean addViewer(Player player) {
        if (this.hologram().isShowState(player)) {
            return false;
        }
        this.hologram().setShowPlayer(player);
        this.hologram().show(player, 0);
        return true;
    }

    @Override
    public boolean addViewers(Collection<Player> players) {
        return players.stream().map(this::addViewer).reduce(false, Boolean::logicalOr);
    }

    @Override
    public boolean isTrackedBy(Player player) {
        return this.hologram().isVisible(player);
    }

    @Override
    public boolean canSee(Player player) {
        return this.hologram().isShowState(player) && !this.hologram().isHideState(player) && this.hologram().canShow(player);
    }

    @Override
    public boolean isVisibleByDefault() {
        return this.hologram().isDefaultVisibleState();
    }

    @Override
    public boolean removeViewer(Player player) {
        if (!this.isTrackedBy(player)) {
            return false;
        }
        this.hologram().removeShowPlayer(player);
        this.hologram().hide(player);
        return true;
    }

    @Override
    public boolean removeViewers(Collection<Player> players) {
        return players.stream().map(this::removeViewer).reduce(false, Boolean::logicalOr);
    }

    @Override
    public double getDisplayRange() {
        return this.hologram().getDisplayRange();
    }

    @Override
    public double getX() {
        return this.getLocation().getX();
    }

    @Override
    public double getY() {
        return this.getLocation().getY();
    }

    @Override
    public double getZ() {
        return this.getLocation().getZ();
    }

    @Override
    public float getPitch() {
        return this.getLocation().getPitch();
    }

    @Override
    public float getYaw() {
        return this.getLocation().getYaw();
    }

    @Override
    public void setDisplayRange(double range) {
        this.hologram().setDisplayRange((int)range);
    }

    @Override
    public void setVisibleByDefault(boolean visible) {
        this.hologram().setDefaultVisibleState(visible);
    }
}

