/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.providers.citizens;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.MobType;
import net.citizensnpcs.api.trait.trait.PlayerFilter;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.thenextlvl.service.api.character.Character;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class CitizensCharacter<T extends Entity>
implements Character<T> {
    protected final NPC npc;

    public CitizensCharacter(NPC npc) {
        this.npc = npc;
    }

    @Override
    public String getName() {
        return this.npc.getRawName();
    }

    @Override
    public boolean isPersistent() {
        return (Boolean)this.npc.data().get(NPC.Metadata.SHOULD_SAVE);
    }

    @Override
    public boolean persist() {
        if (!this.isPersistent()) {
            return false;
        }
        CitizensAPI.getNPCRegistry().saveToStore();
        return true;
    }

    @Override
    public void setPersistent(boolean persistent) {
        this.npc.data().setPersistent(NPC.Metadata.SHOULD_SAVE, (Object)persistent);
    }

    @Override
    public @Unmodifiable Set<Player> getTrackedBy() {
        return this.getEntity().map(Entity::getTrackedBy).orElseGet(Set::of);
    }

    @Override
    public @Unmodifiable Set<Player> getViewers() {
        return this.npc.getTraitOptional(PlayerFilter.class).toJavaUtil().map(PlayerFilter::getPlayerUUIDs).map(players -> players.stream().map(arg_0 -> ((Server)this.getServer()).getPlayer(arg_0)).filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet())).orElseGet(Set::of);
    }

    @Override
    public boolean addViewer(Player player) {
        return this.npc.getTraitOptional(PlayerFilter.class).toJavaUtil().filter(filter -> filter.isHidden(player)).map(filter -> {
            filter.addPlayer(player.getUniqueId());
            return true;
        }).orElse(false);
    }

    @Override
    public boolean addViewers(Collection<Player> players) {
        return players.stream().map(this::addViewer).reduce(false, Boolean::logicalOr);
    }

    @Override
    public boolean isTrackedBy(Player player) {
        return this.getEntity().map(entity -> entity.getTrackedBy().contains(player)).orElse(false);
    }

    @Override
    public boolean canSee(Player player) {
        return !this.npc.isHiddenFrom(player);
    }

    @Override
    public boolean isVisibleByDefault() {
        return this.getEntity().map(Entity::isVisibleByDefault).orElse(false);
    }

    @Override
    public boolean removeViewer(Player player) {
        return this.npc.getTraitOptional(PlayerFilter.class).toJavaUtil().filter(filter -> !filter.isHidden(player)).map(filter -> {
            filter.removePlayer(player.getUniqueId());
            return true;
        }).orElse(false);
    }

    @Override
    public boolean removeViewers(Collection<Player> players) {
        return players.stream().map(this::removeViewer).reduce(false, Boolean::logicalOr);
    }

    @Override
    public double getDisplayRange() {
        return this.npc.getTraitOptional(PlayerFilter.class).toJavaUtil().map(PlayerFilter::getApplyRange).orElse(-1.0);
    }

    @Override
    public void setDisplayRange(double range) {
        this.npc.getTraitOptional(PlayerFilter.class).toJavaUtil().ifPresent(filter -> filter.setApplyRange(range));
    }

    @Override
    public void setVisibleByDefault(boolean visible) {
        this.getEntity().ifPresent(entity -> entity.setVisibleByDefault(visible));
    }

    @Override
    public @Nullable Location getLocation() {
        return this.npc.getStoredLocation();
    }

    @Override
    public Server getServer() {
        return Bukkit.getServer();
    }

    @Override
    public @Nullable World getWorld() {
        return this.getEntity().map(Entity::getWorld).orElse(null);
    }

    @Override
    public boolean isInvulnerable() {
        return this.npc.isProtected();
    }

    @Override
    public void remove() {
        this.npc.destroy();
    }

    @Override
    public void setCollidable(boolean collidable) {
        this.npc.data().setPersistent(NPC.Metadata.COLLIDABLE, (Object)collidable);
    }

    @Override
    public double getX() {
        return this.getEntity().map(Entity::getX).orElse(0.0);
    }

    @Override
    public double getY() {
        return this.getEntity().map(Entity::getY).orElse(0.0);
    }

    @Override
    public double getZ() {
        return this.getEntity().map(Entity::getZ).orElse(0.0);
    }

    @Override
    public float getPitch() {
        return this.getEntity().map(Entity::getPitch).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public float getYaw() {
        return this.getEntity().map(Entity::getYaw).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public CompletableFuture<Boolean> teleportAsync(Location location) {
        return this.getEntity().map(entity -> entity.teleportAsync(location)).orElseGet(() -> {
            this.npc.teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
            return CompletableFuture.completedFuture(true);
        });
    }

    @Override
    public Component getDisplayName() {
        return MiniMessage.miniMessage().deserialize((Object)this.npc.getRawName());
    }

    @Override
    public Optional<T> getEntity() {
        return Optional.ofNullable(this.npc.getEntity()).map(entity -> entity);
    }

    @Override
    public EntityType getType() {
        return (EntityType)this.npc.getTraitOptional(MobType.class).transform(MobType::getType).or((Object)EntityType.PLAYER);
    }

    @Override
    public boolean isSpawned() {
        return this.npc.isSpawned();
    }

    @Override
    public boolean isTablistEntryHidden() {
        return this.npc.shouldRemoveFromTabList();
    }

    @Override
    public boolean spawn(Location location) {
        return this.npc.spawn(location);
    }

    @Override
    public void lookAt(Entity entity) {
        this.lookAt(entity.getLocation());
    }

    @Override
    public void lookAt(Location location) {
        this.npc.faceLocation(location);
    }

    @Override
    public boolean despawn() {
        return this.npc.despawn();
    }

    @Override
    public boolean isCollidable() {
        return (Boolean)this.npc.data().get(NPC.Metadata.COLLIDABLE, (Object)false);
    }

    @Override
    public boolean respawn() {
        Location location = this.getLocation();
        return location != null && this.npc.despawn(DespawnReason.PENDING_RESPAWN) && this.npc.spawn(location);
    }

    @Override
    public void setDisplayName(Component displayName) {
        this.npc.setName((String)MiniMessage.miniMessage().serialize(displayName));
    }

    @Override
    public void setInvulnerable(boolean invulnerable) {
        this.npc.setProtected(invulnerable);
    }

    @Override
    public void setTablistEntryHidden(boolean hidden) {
        this.npc.data().setPersistent(NPC.Metadata.REMOVE_FROM_TABLIST, (Object)hidden);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CitizensCharacter that = (CitizensCharacter)o;
        return Objects.equals(this.npc, that.npc);
    }

    public int hashCode() {
        return Objects.hashCode(this.npc);
    }
}

