/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.placeholder.economy;

import java.util.UUID;
import net.milkbowl.vault2.economy.AccountPermission;
import net.milkbowl.vault2.economy.Economy;
import net.thenextlvl.service.placeholder.api.PlaceholderResolver;
import net.thenextlvl.service.placeholder.api.PlaceholderStore;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class UnlockedEconomyPlaceholderStore
extends PlaceholderStore<Economy> {
    private static final String PLUGIN_NAME = "VaultUnlocked";

    public UnlockedEconomyPlaceholderStore(Plugin plugin) {
        super(plugin, Economy.class);
    }

    @Override
    protected void registerResolvers() {
        this.registerResolver("balance_currency_%s", (provider, player, matcher) -> {
            String currency = this.decode(matcher.group(1));
            return provider.balance(PLUGIN_NAME, player.getUniqueId(), "world", currency).toPlainString();
        });
        this.registerResolver("balance_currency_%s_world_%s", (provider, player, matcher) -> {
            String currency = this.decode(matcher.group(1));
            String world = matcher.group(2);
            return provider.balance(PLUGIN_NAME, player.getUniqueId(), world, currency).toPlainString();
        });
        this.registerResolver("balance_%s", (provider, player, matcher) -> {
            String world = matcher.group(1);
            return provider.balance(PLUGIN_NAME, player.getUniqueId(), world).toPlainString();
        });
        this.registerResolver("balance", (provider, player, matcher) -> provider.balance(PLUGIN_NAME, player.getUniqueId()).toPlainString());
        this.registerResolver("balanceformatted_currency_%s", (provider, player, matcher) -> {
            String currency = this.decode(matcher.group(1));
            return provider.format(PLUGIN_NAME, provider.balance(PLUGIN_NAME, player.getUniqueId(), "world", currency));
        });
        this.registerResolver("balanceformatted_currency_%s_world_%s", (provider, player, matcher) -> {
            String currency = this.decode(matcher.group(1));
            String world = matcher.group(2);
            return provider.format(PLUGIN_NAME, provider.balance(PLUGIN_NAME, player.getUniqueId(), world, currency));
        });
        this.registerResolver("balanceformatted_%s", (provider, player, matcher) -> {
            String world = matcher.group(1);
            return provider.format(PLUGIN_NAME, provider.balance(PLUGIN_NAME, player.getUniqueId(), world));
        });
        this.registerResolver("balanceformatted", (provider, player, matcher) -> provider.format(PLUGIN_NAME, provider.balance(PLUGIN_NAME, player.getUniqueId())));
        this.registerResolver("account_%s", PlaceholderResolver.throwing((provider, player, matcher) -> {
            UUID accountId = UUID.fromString(matcher.group(1));
            return provider.balance(PLUGIN_NAME, accountId).toPlainString();
        }, IllegalArgumentException.class));
        this.registerResolver("account_%s_currency_%s", PlaceholderResolver.throwing((provider, player, matcher) -> {
            UUID accountId = UUID.fromString(matcher.group(1));
            String currency = this.decode(matcher.group(2));
            return provider.balance(PLUGIN_NAME, accountId, "world", currency).toPlainString();
        }, IllegalArgumentException.class));
        this.registerResolver("account_%s_currency_%s_formatted", PlaceholderResolver.throwing((provider, player, matcher) -> {
            UUID accountId = UUID.fromString(matcher.group(1));
            String currency = this.decode(matcher.group(2));
            return provider.format(PLUGIN_NAME, provider.balance(PLUGIN_NAME, accountId, "world", currency));
        }, IllegalArgumentException.class));
        this.registerResolver("account_%s_currency_%s_world_%s", PlaceholderResolver.throwing((provider, player, matcher) -> {
            UUID accountId = UUID.fromString(matcher.group(1));
            String currency = this.decode(matcher.group(2));
            String world = matcher.group(3);
            return provider.balance(PLUGIN_NAME, accountId, world, currency).toPlainString();
        }, IllegalArgumentException.class));
        this.registerResolver("account_%s_currency_%s_world_%s_formatted", PlaceholderResolver.throwing((provider, player, matcher) -> {
            UUID accountId = UUID.fromString(matcher.group(1));
            String currency = this.decode(matcher.group(2));
            String world = matcher.group(3);
            return provider.format(PLUGIN_NAME, provider.balance(PLUGIN_NAME, accountId, world, currency));
        }, IllegalArgumentException.class));
        this.registerResolver("can_%s_%s", PlaceholderResolver.throwing((provider, player, matcher) -> {
            AccountPermission permission;
            UUID accountId = UUID.fromString(matcher.group(2));
            switch (matcher.group(1)) {
                case "deposit": {
                    AccountPermission accountPermission = AccountPermission.DEPOSIT;
                    break;
                }
                case "withdraw": {
                    AccountPermission accountPermission = AccountPermission.WITHDRAW;
                    break;
                }
                case "balance": {
                    AccountPermission accountPermission = AccountPermission.BALANCE;
                    break;
                }
                case "transfer": {
                    AccountPermission accountPermission = AccountPermission.TRANSFER_OWNERSHIP;
                    break;
                }
                case "invite": {
                    AccountPermission accountPermission = AccountPermission.INVITE_MEMBER;
                    break;
                }
                case "remove": {
                    AccountPermission accountPermission = AccountPermission.REMOVE_MEMBER;
                    break;
                }
                case "modify": {
                    AccountPermission accountPermission = AccountPermission.CHANGE_MEMBER_PERMISSION;
                    break;
                }
                case "delete": {
                    AccountPermission accountPermission = AccountPermission.DELETE;
                    break;
                }
                default: {
                    AccountPermission accountPermission = permission = null;
                }
            }
            if (permission == null) {
                return null;
            }
            return provider.hasAccountPermission(PLUGIN_NAME, accountId, player.getUniqueId(), permission) ? "yes" : "no";
        }, IllegalArgumentException.class));
        this.registerResolver("accounts", (provider, player, matcher) -> String.join((CharSequence)", ", provider.accountsMemberOf(PLUGIN_NAME, player.getUniqueId())));
        this.registerResolver("accounts_count", (provider, player, matcher) -> String.valueOf(provider.accountsMemberOf(PLUGIN_NAME, player.getUniqueId()).size()));
        this.registerResolver("currency", (provider, player, matcher) -> provider.defaultCurrencyNameSingular(PLUGIN_NAME));
        this.registerResolver("currencyplural", (provider, player, matcher) -> provider.defaultCurrencyNamePlural(PLUGIN_NAME));
    }

    private String decode(String input) {
        return input.replace("%20", " ").replace("%24", "$").replace("%2B", "+").replace("%26", "&").replace("%2F", "/").replace("%3D", "=");
    }
}

