/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.providers.decentholograms;

import com.destroystokyo.paper.profile.PlayerProfile;
import eu.decentsoftware.holograms.api.holograms.HologramLine;
import eu.decentsoftware.holograms.api.utils.items.HologramItem;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.ResolvableProfile;
import java.util.Objects;
import net.thenextlvl.service.api.hologram.LineType;
import net.thenextlvl.service.providers.decentholograms.DecentHologramLine;
import org.bukkit.Material;
import org.bukkit.block.Skull;
import org.bukkit.block.data.BlockData;
import org.bukkit.inventory.ItemStack;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class DecentBlockHologramLine
extends DecentHologramLine<BlockData> {
    private final boolean small;

    public DecentBlockHologramLine(HologramLine line, boolean small) {
        super(line);
        this.small = small;
    }

    @Override
    public LineType getType() {
        return LineType.BLOCK;
    }

    @Override
    public BlockData getContent() {
        ItemStack item = this.line.getItem().parse(null);
        return item.getType().createBlockData(blockData -> {
            if (!(blockData instanceof Skull)) {
                return;
            }
            Skull skull = (Skull)blockData;
            ResolvableProfile data = (ResolvableProfile)item.getData(DataComponentTypes.PROFILE);
            if (data == null) {
                return;
            }
            PlayerProfile profile = this.getServer().createProfile(data.uuid(), data.name());
            skull.setPlayerProfile(profile);
        });
    }

    @Override
    public void setContent(BlockData content) {
        String type = this.small ? "#SMALLHEAD:" : "#HEAD:";
        ItemStack item = ItemStack.of((Material)content.getMaterial());
        this.line.setContent(type + String.valueOf(HologramItem.fromItemStack((ItemStack)item)));
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DecentBlockHologramLine that = (DecentBlockHologramLine)o;
        return this.small == that.small;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.small);
    }
}

