/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.placeholder.api;

import com.google.common.base.Preconditions;
import java.util.regex.Matcher;
import org.bukkit.OfflinePlayer;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public interface PlaceholderResolver<T> {
    public @Nullable String resolve(T var1, OfflinePlayer var2, Matcher var3) throws RuntimeException;

    @SafeVarargs
    public static <T> PlaceholderResolver<T> throwing(PlaceholderResolver<T> resolver, Class<? extends RuntimeException> ... ignored) {
        Preconditions.checkArgument((ignored.length > 0 ? 1 : 0) != 0, (Object)"At least one exception class must be provided");
        return (provider, player, matcher) -> {
            try {
                return resolver.resolve(provider, player, matcher);
            }
            catch (RuntimeException exception) {
                for (Class clazz : ignored) {
                    if (!clazz.isInstance(exception)) continue;
                    return null;
                }
                throw exception;
            }
        };
    }
}

