/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.listeners;

import java.util.ArrayList;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.milkbowl.vault.permission.Permission;
import net.thenextlvl.service.api.Controller;
import net.thenextlvl.service.api.character.CharacterController;
import net.thenextlvl.service.api.chat.ChatController;
import net.thenextlvl.service.api.group.GroupController;
import net.thenextlvl.service.api.hologram.HologramController;
import net.thenextlvl.service.api.permission.PermissionController;
import net.thenextlvl.service.placeholder.api.PlaceholderExpansionBuilder;
import net.thenextlvl.service.placeholder.chat.ServiceChatPlaceholderStore;
import net.thenextlvl.service.placeholder.economy.ServiceBankPlaceholderStore;
import net.thenextlvl.service.placeholder.economy.ServiceEconomyPlaceholderStore;
import net.thenextlvl.service.placeholder.economy.UnlockedEconomyPlaceholderStore;
import net.thenextlvl.service.placeholder.group.ServiceGroupPlaceholderStore;
import net.thenextlvl.service.providers.citizens.CitizensCharacterController;
import net.thenextlvl.service.providers.citizens.CitizensListener;
import net.thenextlvl.service.providers.decentholograms.DecentHologramController;
import net.thenextlvl.service.providers.fancyholograms.v2.FancyHologramController;
import net.thenextlvl.service.providers.fancynpcs.FancyCharacterController;
import net.thenextlvl.service.providers.fancynpcs.FancyNpcsListener;
import net.thenextlvl.service.providers.groupmanager.GroupManagerChatController;
import net.thenextlvl.service.providers.groupmanager.GroupManagerGroupController;
import net.thenextlvl.service.providers.groupmanager.GroupManagerPermission;
import net.thenextlvl.service.providers.groupmanager.GroupManagerPermissionController;
import net.thenextlvl.service.providers.luckperms.LuckPermsChatController;
import net.thenextlvl.service.providers.luckperms.LuckPermsGroupController;
import net.thenextlvl.service.providers.luckperms.LuckPermsPermissionController;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

@NullMarked
public class PluginListener
implements Listener {
    private final Map<String, Consumer<Plugin>> registrations;
    private final Logger logger;

    public PluginListener(Plugin provider) {
        this.logger = provider.getComponentLogger();
        this.registrations = Map.ofEntries(Map.entry("PlaceholderAPI", plugin -> this.registerPlaceholders(provider)), Map.entry("Citizens", plugin -> this.hookService((Plugin)plugin, (Class)CharacterController.class, () -> new CitizensCharacterController((Plugin)plugin), controller -> new CitizensListener((CharacterController)controller), ServicePriority.Highest)), Map.entry("DecentHolograms", plugin -> this.hookService((Plugin)plugin, (Class)HologramController.class, () -> new DecentHologramController(), ServicePriority.Highest)), Map.entry("FancyNpcs", plugin -> this.hookService((Plugin)plugin, (Class)CharacterController.class, () -> new FancyCharacterController((Plugin)plugin), controller -> new FancyNpcsListener((CharacterController)controller), ServicePriority.High)), Map.entry("GroupManager", plugin -> {
            this.hookService((Plugin)plugin, (Class)ChatController.class, () -> new GroupManagerChatController(), ServicePriority.Low);
            this.hookService((Plugin)plugin, (Class)GroupController.class, () -> new GroupManagerGroupController(), ServicePriority.Low);
            this.hookService((Plugin)plugin, (Class)PermissionController.class, () -> new GroupManagerPermissionController(), ServicePriority.Low);
            this.hook((Plugin)plugin, (Class)Permission.class, () -> new GroupManagerPermission(), Permission::getName, ServicePriority.Low);
        }), Map.entry("FancyHolograms", plugin -> {
            String version = plugin.getPluginMeta().getVersion();
            if (version.startsWith("2")) {
                this.hookService((Plugin)plugin, (Class)HologramController.class, () -> new FancyHologramController(), ServicePriority.High);
            } else if (version.startsWith("3")) {
                this.hookService((Plugin)plugin, (Class)HologramController.class, () -> new net.thenextlvl.service.providers.fancyholograms.v3.FancyHologramController(), ServicePriority.High);
            } else {
                this.logger.warn("Unsupported FancyHolograms version {}", (Object)version);
            }
        }), Map.entry("LuckPerms", plugin -> {
            this.hookService((Plugin)plugin, (Class)ChatController.class, () -> new LuckPermsChatController((Plugin)plugin), ServicePriority.Highest);
            this.hookService((Plugin)plugin, (Class)GroupController.class, () -> new LuckPermsGroupController((Plugin)plugin), ServicePriority.Highest);
            this.hookService((Plugin)plugin, (Class)PermissionController.class, () -> new LuckPermsPermissionController((Plugin)plugin), ServicePriority.Highest);
        }));
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPluginEnable(PluginEnableEvent event) {
        Consumer<Plugin> consumer = this.registrations.get(event.getPlugin().getName());
        if (consumer != null) {
            consumer.accept(event.getPlugin());
        }
    }

    private void registerPlaceholders(Plugin plugin) {
        new PlaceholderExpansionBuilder(plugin).registerStore(new ServiceBankPlaceholderStore(plugin)).registerStore(new ServiceChatPlaceholderStore(plugin)).registerStore(new ServiceEconomyPlaceholderStore(plugin)).registerStore(new ServiceGroupPlaceholderStore(plugin)).register();
        ArrayList<String> authors = new ArrayList<String>(plugin.getPluginMeta().getAuthors());
        authors.add("creatorfromhell");
        new PlaceholderExpansionBuilder(plugin, "vaultunlocked").setAuthors(authors).setVersion("2.13.1").registerStore(new UnlockedEconomyPlaceholderStore(plugin)).register();
    }

    private <T extends Controller> void hookService(Plugin plugin, Class<T> type, Supplier<? extends T> controller, Function<T, Listener> listener, ServicePriority priority) {
        T hook = this.hookService(plugin, type, controller, priority);
        if (hook != null) {
            plugin.getServer().getPluginManager().registerEvents(listener.apply(hook), plugin);
        }
    }

    private <T extends Controller> @Nullable T hookService(Plugin plugin, Class<T> type, Supplier<? extends T> controller, ServicePriority priority) {
        return (T)this.hook(plugin, type, controller, Controller::getName, priority);
    }

    private <T> @Nullable T hook(Plugin plugin, Class<T> type, Supplier<? extends T> controller, Function<T, String> name, ServicePriority priority) {
        try {
            T provider = controller.get();
            plugin.getServer().getServicesManager().register(type, provider, plugin, priority);
            this.logger.info("Initialized support for {} as {} ({})", new Object[]{name.apply(provider), type.getSimpleName(), priority.name()});
            return provider;
        }
        catch (Exception e) {
            this.logger.error("Failed to add {} for {} - make sure you're using a compatible version!", new Object[]{type.getSimpleName(), plugin.getName(), e});
            return null;
        }
    }
}

