/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.wrapper.service;

import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.milkbowl.vault.permission.Permission;
import net.thenextlvl.service.api.permission.PermissionController;
import net.thenextlvl.service.api.permission.PermissionHolder;
import net.thenextlvl.service.wrapper.Wrapper;
import net.thenextlvl.service.wrapper.service.model.WrappedPermissionHolder;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class PermissionServiceWrapper
implements PermissionController,
Wrapper {
    private final Permission permission;
    private final Plugin provider;

    public PermissionServiceWrapper(Permission permission, Plugin provider) {
        this.permission = permission;
        this.provider = provider;
    }

    @Override
    public CompletableFuture<PermissionHolder> loadPermissionHolder(OfflinePlayer player) {
        return CompletableFuture.completedFuture(new WrappedPermissionHolder(null, player, this.permission));
    }

    @Override
    public CompletableFuture<PermissionHolder> loadPermissionHolder(OfflinePlayer player, World world) {
        return CompletableFuture.completedFuture(new WrappedPermissionHolder(world, player, this.permission));
    }

    @Override
    public CompletableFuture<PermissionHolder> loadPermissionHolder(UUID uuid) {
        return this.loadPermissionHolder(this.provider.getServer().getOfflinePlayer(uuid));
    }

    @Override
    public CompletableFuture<PermissionHolder> loadPermissionHolder(UUID uuid, World world) {
        return this.loadPermissionHolder(this.provider.getServer().getOfflinePlayer(uuid), world);
    }

    @Override
    public Optional<PermissionHolder> getPermissionHolder(OfflinePlayer player) {
        return Optional.of(new WrappedPermissionHolder(null, player, this.permission));
    }

    @Override
    public Optional<PermissionHolder> getPermissionHolder(OfflinePlayer player, World world) {
        return Optional.of(new WrappedPermissionHolder(world, player, this.permission));
    }

    @Override
    public Optional<PermissionHolder> getPermissionHolder(UUID uuid) {
        return this.getPermissionHolder(this.provider.getServer().getOfflinePlayer(uuid));
    }

    @Override
    public Optional<PermissionHolder> getPermissionHolder(UUID uuid, World world) {
        return this.getPermissionHolder(this.provider.getServer().getOfflinePlayer(uuid), world);
    }

    @Override
    public Plugin getPlugin() {
        return this.provider;
    }

    @Override
    public String getName() {
        return this.permission.getName() + " Wrapper";
    }
}

