/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.wrapper.service;

import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.milkbowl.vault.chat.Chat;
import net.thenextlvl.service.api.chat.ChatController;
import net.thenextlvl.service.api.chat.ChatProfile;
import net.thenextlvl.service.wrapper.Wrapper;
import net.thenextlvl.service.wrapper.service.model.WrappedChatProfile;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class ChatServiceWrapper
implements ChatController,
Wrapper {
    private final Plugin provider;
    private final Chat chat;

    public ChatServiceWrapper(Chat chat, Plugin provider) {
        this.chat = chat;
        this.provider = provider;
    }

    @Override
    public CompletableFuture<ChatProfile> loadProfile(OfflinePlayer player) {
        return CompletableFuture.completedFuture(new WrappedChatProfile(null, this.chat, player));
    }

    @Override
    public CompletableFuture<ChatProfile> loadProfile(OfflinePlayer player, World world) {
        return CompletableFuture.completedFuture(new WrappedChatProfile(world, this.chat, player));
    }

    @Override
    public CompletableFuture<ChatProfile> loadProfile(UUID uuid) {
        return this.loadProfile(this.provider.getServer().getOfflinePlayer(uuid));
    }

    @Override
    public CompletableFuture<ChatProfile> loadProfile(UUID uuid, World world) {
        return this.loadProfile(this.provider.getServer().getOfflinePlayer(uuid), world);
    }

    @Override
    public Optional<ChatProfile> getProfile(OfflinePlayer player) {
        return Optional.of(new WrappedChatProfile(null, this.chat, player));
    }

    @Override
    public Optional<ChatProfile> getProfile(OfflinePlayer player, World world) {
        return Optional.of(new WrappedChatProfile(world, this.chat, player));
    }

    @Override
    public Optional<ChatProfile> getProfile(UUID uuid) {
        return this.getProfile(this.provider.getServer().getOfflinePlayer(uuid));
    }

    @Override
    public Optional<ChatProfile> getProfile(UUID uuid, World world) {
        return this.getProfile(this.provider.getServer().getOfflinePlayer(uuid), world);
    }

    @Override
    public Plugin getPlugin() {
        return this.provider;
    }

    @Override
    public String getName() {
        return this.chat.getName() + " Wrapper";
    }
}

