/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.wrapper;

import java.util.Optional;
import net.kyori.adventure.util.TriState;
import net.milkbowl.vault.permission.Permission;
import net.thenextlvl.service.api.group.Group;
import net.thenextlvl.service.api.group.GroupController;
import net.thenextlvl.service.api.group.GroupHolder;
import net.thenextlvl.service.api.permission.PermissionController;
import net.thenextlvl.service.api.permission.PermissionHolder;
import net.thenextlvl.service.wrapper.Wrapper;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class VaultPermissionServiceWrapper
extends Permission
implements Wrapper {
    private final @Nullable GroupController groupController;
    private final PermissionController permissionController;

    public VaultPermissionServiceWrapper(@Nullable GroupController groupController, PermissionController permissionController, Plugin plugin) {
        this.groupController = groupController;
        this.permissionController = permissionController;
        this.plugin = plugin;
    }

    @Override
    public String getName() {
        return this.permissionController.getName() + " Wrapper";
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean hasSuperPermsCompat() {
        return true;
    }

    @Override
    public boolean playerHas(@Nullable String world, String player, String permission) {
        return this.getPermissionHolder(player, world).map(holder -> holder.checkPermission(permission)).map(TriState::toBoolean).orElse(false);
    }

    @Override
    public boolean playerAdd(@Nullable String world, String player, String permission) {
        return this.getPermissionHolder(player, world).map(holder -> holder.addPermission(permission)).orElse(false);
    }

    @Override
    public boolean playerRemove(@Nullable String world, String player, String permission) {
        return this.getPermissionHolder(player, world).map(holder -> holder.removePermission(permission)).orElse(false);
    }

    @Override
    public boolean groupHas(@Nullable String world, String groupName, String permission) {
        GroupController groupController = this.groupController();
        return Optional.ofNullable(world).map(arg_0 -> ((Server)this.getPlugin().getServer()).getWorld(arg_0)).flatMap(target -> groupController.getGroup(groupName, (World)target).or(() -> groupController.getGroup(groupName))).map(group -> group.checkPermission(permission)).map(arg_0 -> TriState.TRUE.equals(arg_0)).orElse(false);
    }

    @Override
    public boolean groupAdd(@Nullable String world, String groupName, String permission) {
        GroupController groupController = this.groupController();
        return Optional.ofNullable(world).map(arg_0 -> ((Server)this.getPlugin().getServer()).getWorld(arg_0)).flatMap(target -> groupController.getGroup(groupName, (World)target).or(() -> groupController.getGroup(groupName))).map(group -> group.addPermission(permission)).orElse(false);
    }

    @Override
    public boolean groupRemove(@Nullable String world, String groupName, String permission) {
        GroupController groupController = this.groupController();
        return Optional.ofNullable(world).map(arg_0 -> ((Server)this.getPlugin().getServer()).getWorld(arg_0)).flatMap(target -> groupController.getGroup(groupName, (World)target).or(() -> groupController.getGroup(groupName))).map(group -> group.removePermission(permission)).orElse(false);
    }

    @Override
    public boolean playerInGroup(@Nullable String world, String player, String group) {
        return this.getGroupHolder(player, world).map(holder -> holder.inGroup(group)).orElse(false);
    }

    @Override
    public boolean playerAddGroup(@Nullable String world, String player, String group) {
        return this.getGroupHolder(player, world).map(holder -> holder.addGroup(group)).orElse(false);
    }

    @Override
    public boolean playerRemoveGroup(@Nullable String world, String player, String group) {
        return this.getGroupHolder(player, world).map(holder -> holder.removeGroup(group)).orElse(false);
    }

    @Override
    public String[] getPlayerGroups(@Nullable String world, String player) {
        return this.getGroupHolder(player, world).map(holder -> (String[])holder.getGroups().stream().map(Group::getName).toArray(String[]::new)).orElseGet(() -> new String[0]);
    }

    @Override
    public String getPrimaryGroup(@Nullable String world, String player) {
        return this.getGroupHolder(player, world).map(GroupHolder::getPrimaryGroup).orElse("");
    }

    @Override
    public String[] getGroups() {
        return (String[])this.groupController().getGroups().stream().map(Group::getName).toArray(String[]::new);
    }

    @Override
    public boolean hasGroupSupport() {
        return this.groupController != null;
    }

    private GroupController groupController() throws UnsupportedOperationException {
        if (this.groupController != null) {
            return this.groupController;
        }
        throw new UnsupportedOperationException(this.getName() + " has no group support");
    }

    private Optional<PermissionHolder> getPermissionHolder(@Nullable String player, @Nullable String world) {
        return Optional.ofNullable(player).map(arg_0 -> ((Server)this.getPlugin().getServer()).getOfflinePlayerIfCached(arg_0)).map(offline -> Optional.ofNullable(world).map(arg_0 -> ((Server)this.getPlugin().getServer()).getWorld(arg_0)).map(target -> this.permissionController.loadPermissionHolder((OfflinePlayer)offline, (World)target).join()).orElseGet(() -> this.permissionController.loadPermissionHolder((OfflinePlayer)offline).join()));
    }

    private Optional<GroupHolder> getGroupHolder(@Nullable String player, @Nullable String world) {
        GroupController groupController = this.groupController();
        return Optional.ofNullable(player).map(arg_0 -> ((Server)this.getPlugin().getServer()).getOfflinePlayerIfCached(arg_0)).map(offline -> Optional.ofNullable(world).map(arg_0 -> ((Server)this.getPlugin().getServer()).getWorld(arg_0)).map(target -> groupController.tryGetGroupHolder((OfflinePlayer)offline, (World)target).join()).orElseGet(() -> groupController.tryGetGroupHolder((OfflinePlayer)offline).join()));
    }

    private Plugin getPlugin() {
        assert (this.plugin != null);
        return this.plugin;
    }
}

