/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.wrapper;

import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import net.thenextlvl.service.api.economy.Account;
import net.thenextlvl.service.api.economy.EconomyController;
import net.thenextlvl.service.api.economy.bank.Bank;
import net.thenextlvl.service.api.economy.bank.BankController;
import net.thenextlvl.service.wrapper.Wrapper;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class VaultEconomyServiceWrapper
implements Economy,
Wrapper {
    private final @Nullable BankController bankController;
    private final EconomyController economyController;
    private final Plugin plugin;

    public VaultEconomyServiceWrapper(EconomyController economyController, Plugin plugin) {
        this.bankController = (BankController)plugin.getServer().getServicesManager().load(BankController.class);
        this.economyController = economyController;
        this.plugin = plugin;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public String getName() {
        return this.economyController.getName() + " Wrapper";
    }

    private BankController bankController() throws UnsupportedOperationException {
        if (this.bankController != null) {
            return this.bankController;
        }
        throw new UnsupportedOperationException(this.getName() + " has no bank support");
    }

    @Override
    public boolean hasBankSupport() {
        return this.bankController != null;
    }

    @Override
    public int fractionalDigits() {
        return this.economyController.fractionalDigits();
    }

    @Override
    public String format(double amount) {
        return this.economyController.format(amount);
    }

    @Override
    public String currencyNamePlural() {
        return this.economyController.getCurrencyNamePlural(Locale.US);
    }

    @Override
    public String currencyNameSingular() {
        return this.economyController.getCurrencyNameSingular(Locale.US);
    }

    @Override
    public boolean hasAccount(@Nullable String name) {
        return this.hasAccount(name, null);
    }

    @Override
    public boolean hasAccount(@Nullable OfflinePlayer player) {
        return this.hasAccount(player, null);
    }

    @Override
    public boolean hasAccount(@Nullable String playerName, @Nullable String worldName) {
        OfflinePlayer player = playerName != null ? this.plugin.getServer().getOfflinePlayerIfCached(playerName) : null;
        return this.hasAccount(player, worldName);
    }

    @Override
    public boolean hasAccount(@Nullable OfflinePlayer player, @Nullable String worldName) {
        return this.getAccount(player, worldName).isPresent();
    }

    @Override
    public double getBalance(@Nullable String name) {
        return this.getBalance(name, null);
    }

    @Override
    public double getBalance(@Nullable OfflinePlayer player) {
        return this.getBalance(player, null);
    }

    @Override
    public double getBalance(@Nullable String playerName, @Nullable String worldName) {
        OfflinePlayer player = playerName != null ? this.plugin.getServer().getOfflinePlayerIfCached(playerName) : null;
        return this.getBalance(player, worldName);
    }

    @Override
    public double getBalance(@Nullable OfflinePlayer player, @Nullable String worldName) {
        return this.getAccount(player, worldName).map(Account::getBalance).map(Number::doubleValue).orElse(0.0);
    }

    @Override
    public boolean has(@Nullable String name, double amount) {
        return this.getBalance(name) >= amount;
    }

    @Override
    public boolean has(@Nullable OfflinePlayer player, double amount) {
        return this.getBalance(player) >= amount;
    }

    @Override
    public boolean has(@Nullable String name, @Nullable String worldName, double amount) {
        return this.getBalance(name, worldName) >= amount;
    }

    @Override
    public boolean has(@Nullable OfflinePlayer player, @Nullable String worldName, double amount) {
        return this.getBalance(player, worldName) >= amount;
    }

    @Override
    public EconomyResponse withdrawPlayer(@Nullable String name, double amount) {
        return this.withdrawPlayer(name, null, amount);
    }

    @Override
    public EconomyResponse withdrawPlayer(@Nullable OfflinePlayer player, double amount) {
        return this.withdrawPlayer(player, null, amount);
    }

    @Override
    public EconomyResponse withdrawPlayer(@Nullable String playerName, @Nullable String worldName, double amount) {
        OfflinePlayer player = playerName != null ? this.plugin.getServer().getOfflinePlayerIfCached(playerName) : null;
        return this.withdrawPlayer(player, worldName, amount);
    }

    @Override
    public EconomyResponse withdrawPlayer(@Nullable OfflinePlayer player, @Nullable String worldName, double amount) {
        return this.getAccount(player, worldName).map(account -> {
            BigDecimal balance = account.getBalance();
            BigDecimal withdraw = account.withdraw(amount);
            EconomyResponse.ResponseType responseType = amount != 0.0 && balance.equals(withdraw) ? EconomyResponse.ResponseType.FAILURE : EconomyResponse.ResponseType.SUCCESS;
            return new EconomyResponse(amount, withdraw.doubleValue(), responseType, null);
        }).orElseGet(() -> new EconomyResponse(amount, 0.0, EconomyResponse.ResponseType.FAILURE, null));
    }

    @Override
    public EconomyResponse depositPlayer(@Nullable String name, double amount) {
        return this.depositPlayer(name, null, amount);
    }

    @Override
    public EconomyResponse depositPlayer(@Nullable OfflinePlayer player, double amount) {
        return this.depositPlayer(player, null, amount);
    }

    @Override
    public EconomyResponse depositPlayer(@Nullable String name, @Nullable String worldName, double amount) {
        OfflinePlayer player = name != null ? this.plugin.getServer().getOfflinePlayerIfCached(name) : null;
        return this.depositPlayer(player, worldName, amount);
    }

    @Override
    public EconomyResponse depositPlayer(@Nullable OfflinePlayer player, @Nullable String worldName, double amount) {
        return this.getAccount(player, worldName).map(account -> {
            BigDecimal balance = account.getBalance();
            BigDecimal deposit = account.deposit(amount);
            EconomyResponse.ResponseType responseType = amount != 0.0 && balance.equals(deposit) ? EconomyResponse.ResponseType.FAILURE : EconomyResponse.ResponseType.SUCCESS;
            return new EconomyResponse(amount, deposit.doubleValue(), responseType, null);
        }).orElseGet(() -> new EconomyResponse(amount, 0.0, EconomyResponse.ResponseType.FAILURE, null));
    }

    @Override
    public EconomyResponse createBank(String name, @Nullable String playerName) {
        OfflinePlayer player = playerName != null ? this.plugin.getServer().getOfflinePlayerIfCached(playerName) : null;
        return this.createBank(name, player);
    }

    @Override
    public EconomyResponse createBank(String name, @Nullable OfflinePlayer player) {
        return Optional.ofNullable(player).map(offline -> this.bankController().createBank((OfflinePlayer)offline, name).join()).map(bank -> new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.SUCCESS, null)).orElseGet(() -> new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, null));
    }

    @Override
    public EconomyResponse deleteBank(String name) {
        Boolean deleted = this.bankController().deleteBank(name).join();
        return new EconomyResponse(0.0, 0.0, deleted != false ? EconomyResponse.ResponseType.SUCCESS : EconomyResponse.ResponseType.FAILURE, null);
    }

    @Override
    public EconomyResponse bankBalance(String name) {
        try {
            Bank bank = this.bankController().tryGetBank(name).join();
            return new EconomyResponse(0.0, bank.getBalance().doubleValue(), EconomyResponse.ResponseType.SUCCESS, null);
        }
        catch (Exception e) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, e.getMessage());
        }
    }

    @Override
    public EconomyResponse bankHas(String name, double amount) {
        try {
            Bank bank = this.bankController().tryGetBank(name).join();
            double balance = bank.getBalance().doubleValue();
            EconomyResponse.ResponseType response = balance >= amount ? EconomyResponse.ResponseType.SUCCESS : EconomyResponse.ResponseType.FAILURE;
            return new EconomyResponse(amount, balance, response, null);
        }
        catch (Exception e) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, e.getMessage());
        }
    }

    @Override
    public EconomyResponse bankWithdraw(String name, double amount) {
        try {
            Bank bank = this.bankController().tryGetBank(name).join();
            double balance = bank.withdraw(amount).doubleValue();
            EconomyResponse.ResponseType response = balance >= amount ? EconomyResponse.ResponseType.SUCCESS : EconomyResponse.ResponseType.FAILURE;
            return new EconomyResponse(amount, balance, response, null);
        }
        catch (Exception e) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, e.getMessage());
        }
    }

    @Override
    public EconomyResponse bankDeposit(String name, double amount) {
        try {
            Bank bank = this.bankController().tryGetBank(name).join();
            double balance = bank.deposit(amount).doubleValue();
            EconomyResponse.ResponseType response = balance >= amount ? EconomyResponse.ResponseType.SUCCESS : EconomyResponse.ResponseType.FAILURE;
            return new EconomyResponse(amount, balance, response, null);
        }
        catch (Exception e) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, e.getMessage());
        }
    }

    @Override
    public EconomyResponse isBankOwner(String name, String playerName) {
        OfflinePlayer player = this.plugin.getServer().getOfflinePlayerIfCached(playerName);
        return this.isBankOwner(name, player);
    }

    @Override
    public EconomyResponse isBankOwner(String name, @Nullable OfflinePlayer player) {
        try {
            Bank bank = this.bankController().tryGetBank(name).join();
            EconomyResponse.ResponseType response = player != null && bank.getOwner().equals(player.getUniqueId()) ? EconomyResponse.ResponseType.SUCCESS : EconomyResponse.ResponseType.FAILURE;
            return new EconomyResponse(0.0, bank.getBalance().doubleValue(), response, null);
        }
        catch (Exception e) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, e.getMessage());
        }
    }

    @Override
    public EconomyResponse isBankMember(String name, @Nullable String playerName) {
        OfflinePlayer player = playerName != null ? this.plugin.getServer().getOfflinePlayerIfCached(playerName) : null;
        return this.isBankMember(name, player);
    }

    @Override
    public EconomyResponse isBankMember(String name, @Nullable OfflinePlayer player) {
        try {
            Bank bank = this.bankController().tryGetBank(name).join();
            EconomyResponse.ResponseType response = player != null && bank.isMember(player.getUniqueId()) ? EconomyResponse.ResponseType.SUCCESS : EconomyResponse.ResponseType.FAILURE;
            return new EconomyResponse(0.0, bank.getBalance().doubleValue(), response, null);
        }
        catch (Exception e) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, e.getMessage());
        }
    }

    @Override
    public List<String> getBanks() {
        return this.bankController().getBanks().stream().map(Bank::getName).toList();
    }

    @Override
    public boolean createPlayerAccount(@Nullable String playerName) {
        OfflinePlayer player = playerName != null ? this.plugin.getServer().getOfflinePlayerIfCached(playerName) : null;
        return player != null && this.createPlayerAccount(player);
    }

    @Override
    public boolean createPlayerAccount(@Nullable OfflinePlayer player) {
        return this.createPlayerAccount(player, null);
    }

    @Override
    public boolean createPlayerAccount(@Nullable String playerName, @Nullable String worldName) {
        OfflinePlayer player = playerName != null ? this.plugin.getServer().getOfflinePlayerIfCached(playerName) : null;
        return player != null && this.createPlayerAccount(player, worldName);
    }

    @Override
    public boolean createPlayerAccount(@Nullable OfflinePlayer player, @Nullable String worldName) {
        return Optional.ofNullable(player).map(offline -> Optional.ofNullable(worldName).map(arg_0 -> ((Server)this.plugin.getServer()).getWorld(arg_0)).map(world -> this.economyController.createAccount((OfflinePlayer)offline, (World)world).join()).orElseGet(() -> this.economyController.createAccount((OfflinePlayer)offline).join())).isPresent();
    }

    private Optional<Account> getAccount(@Nullable OfflinePlayer player, @Nullable String worldName) {
        return Optional.ofNullable(player).flatMap(offline -> Optional.ofNullable(worldName).map(arg_0 -> ((Server)this.plugin.getServer()).getWorld(arg_0)).flatMap(world -> this.economyController.tryGetAccount((OfflinePlayer)offline, (World)world).join()).or(() -> this.economyController.tryGetAccount((OfflinePlayer)offline).join()));
    }
}

