/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.providers.luckperms;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kyori.adventure.util.TriState;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.model.data.DataMutateResult;
import net.luckperms.api.model.group.Group;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.types.MetaNode;
import net.luckperms.api.query.QueryOptions;
import net.luckperms.api.util.Tristate;
import net.thenextlvl.service.api.group.GroupHolder;
import net.thenextlvl.service.providers.luckperms.LuckPermsGroup;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public record LuckPermsPermissionHolder(User user, QueryOptions options) implements GroupHolder
{
    @Override
    public @Unmodifiable Map<String, Boolean> getPermissions() {
        return this.user().getCachedData().getPermissionData(this.options()).getPermissionMap();
    }

    @Override
    public TriState checkPermission(String permission) {
        return switch (this.user().getCachedData().getPermissionData(this.options()).checkPermission(permission)) {
            default -> throw new MatchException(null, null);
            case Tristate.FALSE -> TriState.FALSE;
            case Tristate.TRUE -> TriState.TRUE;
            case Tristate.UNDEFINED -> TriState.NOT_SET;
        };
    }

    @Override
    public boolean addPermission(String permission) {
        return this.setPermission(permission, true);
    }

    @Override
    public boolean removePermission(String permission) {
        DataMutateResult result = this.user().data().remove((Node)Node.builder((String)permission).context((ContextSet)this.options().context()).build());
        LuckPermsProvider.get().getUserManager().saveUser(this.user());
        return result.wasSuccessful();
    }

    @Override
    public boolean setPermission(String permission, boolean value) {
        DataMutateResult result = this.user().data().add((Node)Node.builder((String)permission).value(value).context((ContextSet)this.options().context()).build());
        LuckPermsProvider.get().getUserManager().saveUser(this.user());
        return result.wasSuccessful();
    }

    @Override
    public <T> Optional<T> getInfoNode(String key, Function<String, T> mapper) {
        return this.user().getCachedData().getMetaData(this.options()).getMetaValue(key, mapper);
    }

    @Override
    public boolean setInfoNode(String key, String value) {
        DataMutateResult result = this.user().data().add((Node)((MetaNode.Builder)MetaNode.builder((String)key, (String)value).context((ContextSet)this.options().context())).build());
        LuckPermsProvider.get().getUserManager().saveUser(this.user());
        return result.wasSuccessful();
    }

    @Override
    public boolean removeInfoNode(String key) {
        this.user().data().clear((ContextSet)this.options().context(), node -> node.getKey().equals(key));
        LuckPermsProvider.get().getUserManager().saveUser(this.user());
        return true;
    }

    @Override
    public boolean removeInfoNode(String key, String value) {
        DataMutateResult result = this.user().data().remove((Node)((MetaNode.Builder)MetaNode.builder((String)key, (String)value).context((ContextSet)this.options().context())).build());
        LuckPermsProvider.get().getUserManager().saveUser(this.user());
        return result.wasSuccessful();
    }

    @Override
    public Set<net.thenextlvl.service.api.group.Group> getGroups() {
        return this.user().getInheritedGroups(this.options()).stream().map(group -> new LuckPermsGroup((Group)group, this.options(), null)).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public String getPrimaryGroup() {
        return this.user().getPrimaryGroup();
    }

    @Override
    public boolean addGroup(net.thenextlvl.service.api.group.Group group) {
        return this.addGroup(group.getName());
    }

    @Override
    public boolean addGroup(String name) {
        return this.addPermission("group." + name);
    }

    @Override
    public boolean inGroup(net.thenextlvl.service.api.group.Group group) {
        return this.inGroup(group.getName());
    }

    @Override
    public boolean inGroup(String name) {
        return this.checkPermission("group." + name).equals((Object)TriState.TRUE);
    }

    @Override
    public boolean removeGroup(net.thenextlvl.service.api.group.Group group) {
        return this.removeGroup(group.getName());
    }

    @Override
    public boolean removeGroup(String name) {
        return this.removePermission("group." + name);
    }

    @Override
    public boolean setPrimaryGroup(net.thenextlvl.service.api.group.Group group) {
        return this.setPrimaryGroup(group.getName());
    }

    @Override
    public boolean setPrimaryGroup(String name) {
        return this.user.setPrimaryGroup(name).wasSuccessful();
    }
}

