/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.providers.groupmanager;

import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.thenextlvl.service.api.permission.PermissionController;
import net.thenextlvl.service.api.permission.PermissionHolder;
import net.thenextlvl.service.providers.groupmanager.GroupManagerPermissionHolder;
import org.anjocaido.groupmanager.GroupManager;
import org.anjocaido.groupmanager.data.User;
import org.anjocaido.groupmanager.dataholder.OverloadedWorldHolder;
import org.anjocaido.groupmanager.dataholder.WorldDataHolder;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class GroupManagerPermissionController
implements PermissionController {
    private final GroupManager groupManager = (GroupManager)JavaPlugin.getPlugin(GroupManager.class);

    @Override
    public CompletableFuture<PermissionHolder> loadPermissionHolder(UUID uuid) {
        OverloadedWorldHolder holder = this.groupManager.getWorldsHolder().getDefaultWorld();
        return CompletableFuture.completedFuture(this.getHolder((WorldDataHolder)holder, uuid).orElse(null));
    }

    @Override
    public CompletableFuture<PermissionHolder> loadPermissionHolder(UUID uuid, World world) {
        OverloadedWorldHolder holder = this.groupManager.getWorldsHolder().getWorldData(world.getName());
        return CompletableFuture.completedFuture(this.getHolder((WorldDataHolder)holder, uuid).orElse(null));
    }

    @Override
    public Optional<PermissionHolder> getPermissionHolder(UUID uuid) {
        return Optional.empty();
    }

    @Override
    public Optional<PermissionHolder> getPermissionHolder(UUID uuid, World world) {
        return Optional.empty();
    }

    private Optional<PermissionHolder> getHolder(@Nullable WorldDataHolder holder, UUID uuid) {
        return holder != null ? Optional.ofNullable(holder.getUser(uuid.toString())).map(user -> new GroupManagerPermissionHolder((User)user, holder)) : Optional.empty();
    }

    @Override
    public Plugin getPlugin() {
        return this.groupManager;
    }

    @Override
    public String getName() {
        return "GroupManager";
    }
}

