/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.providers.fancynpcs;

import de.oliver.fancynpcs.api.FancyNpcsPlugin;
import de.oliver.fancynpcs.api.Npc;
import de.oliver.fancynpcs.api.NpcAttribute;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.thenextlvl.service.api.character.Character;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public record FancyCharacter<T extends Entity>(Npc npc) implements Character<T>
{
    @Override
    public CompletableFuture<Boolean> teleportAsync(Location location) {
        this.npc().getData().setLocation(location);
        this.npc().moveForAll(false);
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public Component getDisplayName() {
        return MiniMessage.miniMessage().deserialize((Object)this.npc.getData().getDisplayName());
    }

    @Override
    public Optional<T> getEntity() {
        return Optional.empty();
    }

    @Override
    public EntityType getType() {
        return this.npc().getData().getType();
    }

    @Override
    public @Nullable Location getLocation() {
        return this.npc().getData().getLocation();
    }

    @Override
    public Server getServer() {
        return Bukkit.getServer();
    }

    @Override
    public @Nullable World getWorld() {
        Location location = this.getLocation();
        return location != null ? location.getWorld() : null;
    }

    @Override
    public boolean isInvulnerable() {
        return false;
    }

    @Override
    public void remove() {
        this.npc().removeForAll();
        FancyNpcsPlugin.get().getNpcManager().removeNpc(this.npc());
    }

    @Override
    public void setCollidable(boolean collidable) {
        this.npc().getData().setCollidable(collidable);
    }

    @Override
    public double getX() {
        Location location = this.getLocation();
        return location != null ? location.getX() : 0.0;
    }

    @Override
    public double getY() {
        Location location = this.getLocation();
        return location != null ? location.getY() : 0.0;
    }

    @Override
    public double getZ() {
        Location location = this.getLocation();
        return location != null ? location.getZ() : 0.0;
    }

    @Override
    public float getPitch() {
        Location location = this.getLocation();
        return location != null ? location.getPitch() : 0.0f;
    }

    @Override
    public float getYaw() {
        Location location = this.getLocation();
        return location != null ? location.getYaw() : 0.0f;
    }

    @Override
    public boolean isSpawned() {
        return true;
    }

    @Override
    public boolean isTablistEntryHidden() {
        return !this.npc().getData().isShowInTab();
    }

    @Override
    public boolean spawn(Location location) {
        this.npc().getData().setLocation(location);
        this.npc().getData().setSpawnEntity(true);
        this.npc().spawnForAll();
        return true;
    }

    @Override
    public void lookAt(Entity entity) {
        this.lookAt(entity.getLocation());
    }

    @Override
    public void lookAt(Location target) {
        Location location = this.npc().getData().getLocation().clone();
        Location direction = location.setDirection(target.clone().subtract(location).toVector());
        this.teleportAsync(direction);
    }

    @Override
    public boolean despawn() {
        this.npc().getData().setSpawnEntity(false);
        this.npc().removeForAll();
        return true;
    }

    @Override
    public boolean isCollidable() {
        return this.npc().getData().isCollidable();
    }

    @Override
    public boolean respawn() {
        this.npc().removeForAll();
        this.npc().spawnForAll();
        return true;
    }

    @Override
    public void setDisplayName(Component displayName) {
        this.npc().getData().setDisplayName((String)MiniMessage.miniMessage().serialize(displayName));
        this.npc().updateForAll();
    }

    @Override
    public void setInvulnerable(boolean invulnerable) {
    }

    @Override
    public void setTablistEntryHidden(boolean hidden) {
        this.npc().getData().setShowInTab(!hidden);
    }

    @Override
    public String getName() {
        return this.npc().getData().getName();
    }

    @Override
    public boolean isPersistent() {
        return this.npc().isSaveToFile();
    }

    @Override
    public boolean persist() {
        if (!this.isPersistent()) {
            return false;
        }
        FancyNpcsPlugin.get().getNpcManager().saveNpcs(true);
        return true;
    }

    @Override
    public void setPersistent(boolean persistent) {
        this.npc().setSaveToFile(persistent);
    }

    @Override
    public @Unmodifiable Set<Player> getTrackedBy() {
        return this.npc().getIsVisibleForPlayer().keySet().stream().map(arg_0 -> ((Server)this.getServer()).getPlayer(arg_0)).filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public @Unmodifiable Set<Player> getViewers() {
        return this.getServer().getOnlinePlayers().stream().filter(this::canSee).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public boolean addViewer(Player player) {
        if (!this.canSee(player)) {
            return false;
        }
        this.npc().spawn(player);
        return true;
    }

    @Override
    public boolean addViewers(Collection<Player> players) {
        return players.stream().map(this::addViewer).reduce(false, Boolean::logicalOr);
    }

    @Override
    public boolean isTrackedBy(Player player) {
        return this.npc().getIsVisibleForPlayer().containsKey(player.getUniqueId());
    }

    @Override
    public boolean canSee(Player player) {
        FancyNpcsPlugin plugin = FancyNpcsPlugin.get();
        int visibilityDistance = plugin.getFancyNpcConfig().getVisibilityDistance();
        if (!this.npc().getData().isSpawnEntity()) {
            return false;
        }
        if (this.getLocation() == null) {
            return false;
        }
        if (!player.getWorld().equals((Object)this.getWorld())) {
            return false;
        }
        double distanceSquared = this.getLocation().distanceSquared(player.getLocation());
        if (distanceSquared > (double)(visibilityDistance * visibilityDistance)) {
            return false;
        }
        NpcAttribute attribute = plugin.getAttributeManager().getAttributeByName(EntityType.PLAYER, "invisible");
        return plugin.getFancyNpcConfig().isSkipInvisibleNpcs() && this.npc().getData().getAttributes().getOrDefault(attribute, "false").equalsIgnoreCase("true") && !this.npc().getData().isGlowing() && this.npc().getData().getEquipment().isEmpty();
    }

    @Override
    public boolean isVisibleByDefault() {
        return true;
    }

    @Override
    public boolean removeViewer(Player player) {
        if (!this.isTrackedBy(player)) {
            return false;
        }
        this.npc().remove(player);
        return true;
    }

    @Override
    public boolean removeViewers(Collection<Player> players) {
        return players.stream().map(this::removeViewer).reduce(false, Boolean::logicalOr);
    }

    @Override
    public double getDisplayRange() {
        return FancyNpcsPlugin.get().getFancyNpcConfig().getVisibilityDistance();
    }

    @Override
    public void setDisplayRange(double range) {
    }

    @Override
    public void setVisibleByDefault(boolean visible) {
    }
}

