/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.providers.decentholograms;

import eu.decentsoftware.holograms.api.DHAPI;
import eu.decentsoftware.holograms.api.DecentHologramsAPI;
import eu.decentsoftware.holograms.api.holograms.Hologram;
import eu.decentsoftware.holograms.api.holograms.HologramLine;
import eu.decentsoftware.holograms.api.utils.items.HologramItem;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.thenextlvl.service.api.capability.CapabilityException;
import net.thenextlvl.service.api.hologram.HologramCapability;
import net.thenextlvl.service.api.hologram.HologramController;
import net.thenextlvl.service.providers.decentholograms.DecentBlockHologramLine;
import net.thenextlvl.service.providers.decentholograms.DecentEntityHologramLine;
import net.thenextlvl.service.providers.decentholograms.DecentHologram;
import net.thenextlvl.service.providers.decentholograms.DecentItemHologramLine;
import net.thenextlvl.service.providers.decentholograms.DecentTextHologramLine;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class DecentHologramController
implements HologramController {
    private final EnumSet<HologramCapability> capabilities = EnumSet.of(HologramCapability.BLOCK_LINES, HologramCapability.ENTITY_LINES, HologramCapability.ITEM_LINES, HologramCapability.TEXT_LINES, HologramCapability.MULTILINE);

    @Override
    public net.thenextlvl.service.api.hologram.Hologram createHologram(String name, Location location, Collection<net.thenextlvl.service.api.hologram.HologramLine<?>> lines) throws CapabilityException {
        DecentHologram hologram = new DecentHologram(DHAPI.createHologram((String)name, (Location)location, (boolean)false));
        hologram.addLines(lines);
        return hologram;
    }

    @Override
    public net.thenextlvl.service.api.hologram.HologramLine<BlockData> createLine(BlockData block) throws CapabilityException {
        ItemStack item = ItemStack.of((Material)block.getMaterial());
        HologramLine line = new HologramLine(null, new Location(null, 0.0, 0.0, 0.0), "#HEAD:" + HologramItem.fromItemStack((ItemStack)item).getContent());
        return new DecentBlockHologramLine(line, false);
    }

    @Override
    public net.thenextlvl.service.api.hologram.HologramLine<Component> createLine(Component text) throws CapabilityException {
        HologramLine line = new HologramLine(null, new Location(null, 0.0, 0.0, 0.0), LegacyComponentSerializer.legacyAmpersand().serialize(text));
        return new DecentTextHologramLine(line);
    }

    @Override
    public net.thenextlvl.service.api.hologram.HologramLine<EntityType> createLine(EntityType entity) throws CapabilityException {
        HologramLine line = new HologramLine(null, new Location(null, 0.0, 0.0, 0.0), "#ENTITY:" + entity.name());
        return new DecentEntityHologramLine(line);
    }

    @Override
    public net.thenextlvl.service.api.hologram.HologramLine<ItemStack> createLine(ItemStack itemStack) throws CapabilityException {
        HologramLine line = new HologramLine(null, new Location(null, 0.0, 0.0, 0.0), "#ICON:" + HologramItem.fromItemStack((ItemStack)itemStack).getContent());
        return new DecentItemHologramLine(line);
    }

    @Override
    public @Unmodifiable List<net.thenextlvl.service.api.hologram.Hologram> getHolograms() {
        return Hologram.getCachedHolograms().stream().map(DecentHologram::new).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public @Unmodifiable List<net.thenextlvl.service.api.hologram.Hologram> getHolograms(Player player) {
        return Hologram.getCachedHolograms().stream().filter(hologram -> hologram.isVisible(player)).map(DecentHologram::new).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public @Unmodifiable List<net.thenextlvl.service.api.hologram.Hologram> getHolograms(World world) {
        return Hologram.getCachedHolograms().stream().filter(hologram -> world.equals((Object)hologram.getLocation().getWorld())).map(DecentHologram::new).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public Optional<net.thenextlvl.service.api.hologram.Hologram> getHologram(String name) {
        return Optional.ofNullable(DHAPI.getHologram((String)name)).map(DecentHologram::new);
    }

    @Override
    public Plugin getPlugin() {
        return DecentHologramsAPI.get().getPlugin();
    }

    @Override
    public String getName() {
        return "DecentHolograms";
    }

    @Override
    public @Unmodifiable EnumSet<HologramCapability> getCapabilities() {
        return EnumSet.copyOf(this.capabilities);
    }

    @Override
    public boolean hasCapabilities(Collection<HologramCapability> capabilities) {
        return this.capabilities.containsAll(capabilities);
    }

    @Override
    public boolean hasCapability(HologramCapability capability) {
        return this.capabilities.contains(capability);
    }
}

