/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.commands.brigadier;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.Optional;
import net.thenextlvl.service.ServicePlugin;
import org.jspecify.annotations.NullMarked;

@NullMarked
public abstract class BrigadierCommand {
    protected final ServicePlugin plugin;
    private final String permission;
    private final String name;

    protected BrigadierCommand(ServicePlugin plugin, String name, String permission) {
        this.plugin = plugin;
        this.permission = permission;
        this.name = name;
    }

    protected LiteralArgumentBuilder<CommandSourceStack> create() {
        return (LiteralArgumentBuilder)Commands.literal((String)this.name).requires(this::canUse);
    }

    protected boolean canUse(CommandSourceStack source) {
        return source.getSender().hasPermission(this.permission);
    }

    protected <T> Optional<T> tryGetArgument(CommandContext<CommandSourceStack> context, String name, Class<T> type) {
        try {
            return Optional.of(context.getArgument(name, type));
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().equals("No such argument '" + name + "' exists on this command")) {
                return Optional.empty();
            }
            throw e;
        }
    }
}

