/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.api.permission;

import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.thenextlvl.service.api.Controller;
import net.thenextlvl.service.api.permission.PermissionHolder;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.jspecify.annotations.NullMarked;

@NullMarked
public interface PermissionController
extends Controller {
    default public CompletableFuture<PermissionHolder> loadPermissionHolder(OfflinePlayer player) {
        return this.loadPermissionHolder(player.getUniqueId());
    }

    default public CompletableFuture<PermissionHolder> loadPermissionHolder(OfflinePlayer player, World world) {
        return this.loadPermissionHolder(player.getUniqueId(), world);
    }

    public CompletableFuture<PermissionHolder> loadPermissionHolder(UUID var1);

    public CompletableFuture<PermissionHolder> loadPermissionHolder(UUID var1, World var2);

    default public CompletableFuture<PermissionHolder> tryGetPermissionHolder(OfflinePlayer player) {
        return this.getPermissionHolder(player).map(CompletableFuture::completedFuture).orElseGet(() -> this.loadPermissionHolder(player));
    }

    default public CompletableFuture<PermissionHolder> tryGetPermissionHolder(OfflinePlayer player, World world) {
        return this.getPermissionHolder(player, world).map(CompletableFuture::completedFuture).orElseGet(() -> this.loadPermissionHolder(player, world));
    }

    default public CompletableFuture<PermissionHolder> tryGetPermissionHolder(UUID uuid) {
        return this.getPermissionHolder(uuid).map(CompletableFuture::completedFuture).orElseGet(() -> this.loadPermissionHolder(uuid));
    }

    default public CompletableFuture<PermissionHolder> tryGetPermissionHolder(UUID uuid, World world) {
        return this.getPermissionHolder(uuid, world).map(CompletableFuture::completedFuture).orElseGet(() -> this.loadPermissionHolder(uuid, world));
    }

    default public Optional<PermissionHolder> getPermissionHolder(OfflinePlayer player) {
        return this.getPermissionHolder(player.getUniqueId());
    }

    default public Optional<PermissionHolder> getPermissionHolder(OfflinePlayer player, World world) {
        return this.getPermissionHolder(player.getUniqueId(), world);
    }

    public Optional<PermissionHolder> getPermissionHolder(UUID var1);

    public Optional<PermissionHolder> getPermissionHolder(UUID var1, World var2);
}

