/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.api.economy;

import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.thenextlvl.service.api.Controller;
import net.thenextlvl.service.api.economy.Account;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public interface EconomyController
extends Controller {
    public String format(Number var1);

    public int fractionalDigits();

    public String getCurrencyNamePlural(Locale var1);

    public String getCurrencyNameSingular(Locale var1);

    public String getCurrencySymbol();

    public CompletableFuture<@Unmodifiable Set<Account>> loadAccounts();

    public @Unmodifiable Set<Account> getAccounts();

    default public Optional<Account> getAccount(OfflinePlayer player) {
        return this.getAccount(player.getUniqueId());
    }

    default public Optional<Account> getAccount(OfflinePlayer player, World world) {
        return this.getAccount(player.getUniqueId(), world);
    }

    public Optional<Account> getAccount(UUID var1);

    public Optional<Account> getAccount(UUID var1, World var2);

    default public CompletableFuture<Optional<Account>> tryGetAccount(OfflinePlayer player) {
        return this.getAccount(player).map(account -> CompletableFuture.completedFuture(Optional.of(account))).orElseGet(() -> this.loadAccount(player));
    }

    default public CompletableFuture<Optional<Account>> tryGetAccount(OfflinePlayer player, World world) {
        return this.getAccount(player, world).map(account -> CompletableFuture.completedFuture(Optional.of(account))).orElseGet(() -> this.loadAccount(player, world));
    }

    default public CompletableFuture<Optional<Account>> tryGetAccount(UUID uuid) {
        return this.getAccount(uuid).map(account -> CompletableFuture.completedFuture(Optional.of(account))).orElseGet(() -> this.loadAccount(uuid));
    }

    default public CompletableFuture<Optional<Account>> tryGetAccount(UUID uuid, World world) {
        return this.getAccount(uuid, world).map(account -> CompletableFuture.completedFuture(Optional.of(account))).orElseGet(() -> this.loadAccount(uuid, world));
    }

    default public CompletableFuture<Account> createAccount(OfflinePlayer player) {
        return this.createAccount(player.getUniqueId());
    }

    default public CompletableFuture<Account> createAccount(OfflinePlayer player, World world) {
        return this.createAccount(player.getUniqueId(), world);
    }

    public CompletableFuture<Account> createAccount(UUID var1);

    public CompletableFuture<Account> createAccount(UUID var1, World var2);

    default public CompletableFuture<Optional<Account>> loadAccount(OfflinePlayer player) {
        return this.loadAccount(player.getUniqueId());
    }

    default public CompletableFuture<Optional<Account>> loadAccount(OfflinePlayer player, World world) {
        return this.loadAccount(player.getUniqueId(), world);
    }

    public CompletableFuture<Optional<Account>> loadAccount(UUID var1);

    public CompletableFuture<Optional<Account>> loadAccount(UUID var1, World var2);

    default public CompletableFuture<Boolean> deleteAccount(Account account) {
        return account.getWorld().map(world -> this.deleteAccount(account.getOwner(), (World)world)).orElseGet(() -> this.deleteAccount(account.getOwner()));
    }

    default public CompletableFuture<Boolean> deleteAccount(OfflinePlayer player) {
        return this.deleteAccount(player.getUniqueId());
    }

    default public CompletableFuture<Boolean> deleteAccount(OfflinePlayer player, World world) {
        return this.deleteAccount(player.getUniqueId(), world);
    }

    public CompletableFuture<Boolean> deleteAccount(UUID var1);

    public CompletableFuture<Boolean> deleteAccount(UUID var1, World var2);
}

