/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service;

import dev.faststats.bukkit.BukkitMetrics;
import dev.faststats.core.chart.Chart;
import dev.faststats.core.chart.ChartId;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.nio.file.Path;
import java.util.Locale;
import java.util.function.Function;
import net.kyori.adventure.key.Key;
import net.milkbowl.vault.Vault;
import net.thenextlvl.i18n.ComponentBundle;
import net.thenextlvl.service.api.Controller;
import net.thenextlvl.service.api.character.CharacterController;
import net.thenextlvl.service.api.chat.ChatController;
import net.thenextlvl.service.api.economy.EconomyController;
import net.thenextlvl.service.api.economy.bank.BankController;
import net.thenextlvl.service.api.group.GroupController;
import net.thenextlvl.service.api.hologram.HologramController;
import net.thenextlvl.service.api.permission.PermissionController;
import net.thenextlvl.service.commands.ServiceCommand;
import net.thenextlvl.service.listeners.PluginListener;
import net.thenextlvl.service.listeners.ServiceListener;
import net.thenextlvl.service.providers.superperms.SuperPermsPermissionController;
import net.thenextlvl.service.utils.bstats.bukkit.Metrics;
import net.thenextlvl.service.utils.bstats.charts.SimplePie;
import net.thenextlvl.service.version.PluginVersionChecker;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.ServicePriority;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class ServicePlugin
extends Vault {
    private final PluginVersionChecker versionChecker = new PluginVersionChecker((Plugin)this);
    private final Metrics metrics = new Metrics((Plugin)this, 23083);
    private final Key key = Key.key((String)"service_io", (String)"translations");
    private final Path translations = this.getDataPath().resolve("translations");
    private final ComponentBundle bundle = ComponentBundle.builder(this.key, this.translations).placeholder("prefix", "prefix").resource("service-io.properties", Locale.US).resource("service-io_german.properties", Locale.GERMANY).build();
    private final dev.faststats.core.Metrics fastStats = BukkitMetrics.factory().addChart(this.createChart(BankController.class, Controller::getName, "bank_providers")).addChart(this.createChart(GroupController.class, Controller::getName, "group_providers")).addChart(this.createChart(ChatController.class, Controller::getName, "chat_providers")).addChart(this.createChart(EconomyController.class, Controller::getName, "economy_providers")).addChart(this.createChart(PermissionController.class, Controller::getName, "permission_providers")).addChart(this.createChart(HologramController.class, Controller::getName, "hologram_providers")).addChart(this.createChart(CharacterController.class, Controller::getName, "npc_providers")).token("f7e1aef24e2f8fe48abfb84ccfae5163").create((Plugin)this);

    public void onLoad() {
        this.versionChecker.checkVersion();
        this.registerServices();
        this.registerCommands();
    }

    public void onEnable() {
        this.registerListeners();
        this.addCustomCharts();
    }

    public void onDisable() {
        this.metrics.shutdown();
        this.fastStats.shutdown();
    }

    private void registerServices() {
        this.getServer().getServicesManager().register(PermissionController.class, (Object)new SuperPermsPermissionController((Plugin)this), (Plugin)this, ServicePriority.Lowest);
        this.getComponentLogger().debug("Added SuperPerms as backup permission provider (Lowest)");
    }

    private void registerListeners() {
        this.getServer().getPluginManager().registerEvents((Listener)new ServiceListener((Plugin)this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PluginListener((Plugin)this), (Plugin)this);
    }

    private void registerCommands() {
        this.getLifecycleManager().registerEventHandler(LifecycleEvents.COMMANDS.newHandler(event -> ((Commands)event.registrar()).register(ServiceCommand.create(this))));
    }

    public ComponentBundle bundle() {
        return this.bundle;
    }

    private void addCustomCharts() {
        this.addCustomChart(BankController.class, Controller::getName, "bank_provider");
        this.addCustomChart(GroupController.class, Controller::getName, "group_provider");
        this.addCustomChart(ChatController.class, Controller::getName, "chat_provider");
        this.addCustomChart(EconomyController.class, Controller::getName, "economy_provider");
        this.addCustomChart(PermissionController.class, Controller::getName, "permission_provider");
        this.addCustomChart(HologramController.class, Controller::getName, "hologram_provider");
        this.addCustomChart(CharacterController.class, Controller::getName, "npc_provider");
    }

    private <T> void addCustomChart(Class<T> service, Function<T, String> function, String chartId) {
        Object loaded = this.getServer().getServicesManager().load(service);
        this.metrics.addCustomChart(new SimplePie(chartId, () -> loaded != null ? (String)function.apply(loaded) : "None"));
    }

    private <T> Chart<String[]> createChart(Class<T> service, Function<T, String> function, @ChartId String chartId) {
        return Chart.stringArray(chartId, () -> (String[])this.getServer().getServicesManager().getRegistrations(service).stream().map(RegisteredServiceProvider::getProvider).map(function).toArray(String[]::new));
    }
}

