/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault.permission;

import java.util.logging.Logger;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.Nullable;

public abstract class Permission {
    protected static final Logger log = Logger.getLogger("Minecraft");
    protected @Nullable Plugin plugin = null;

    public abstract String getName();

    public abstract boolean isEnabled();

    public abstract boolean hasSuperPermsCompat();

    @Deprecated(since="1.4")
    public boolean has(@Nullable String world, String player, String permission) {
        return this.playerHas(world, player, permission);
    }

    @Deprecated(since="1.4")
    public boolean has(@Nullable World world, String player, String permission) {
        return this.playerHas(world != null ? world.getName() : null, player, permission);
    }

    public boolean has(CommandSender sender, String permission) {
        return sender.hasPermission(permission);
    }

    public boolean has(Player player, String permission) {
        return player.hasPermission(permission);
    }

    @Deprecated(since="1.4")
    public abstract boolean playerHas(@Nullable String var1, String var2, String var3);

    @Deprecated(since="1.4")
    public boolean playerHas(@Nullable World world, String player, String permission) {
        return this.playerHas(world != null ? world.getName() : null, player, permission);
    }

    public boolean playerHas(@Nullable String world, OfflinePlayer player, String permission) {
        return player.getName() != null && this.has(world, player.getName(), permission);
    }

    public boolean playerHas(Player player, String permission) {
        return this.has(player, permission);
    }

    @Deprecated(since="1.4")
    public abstract boolean playerAdd(@Nullable String var1, String var2, String var3);

    @Deprecated(since="1.4")
    public boolean playerAdd(@Nullable World world, String player, String permission) {
        return this.playerAdd(world != null ? world.getName() : null, player, permission);
    }

    public boolean playerAdd(@Nullable String world, OfflinePlayer player, String permission) {
        return player.getName() != null && this.playerAdd(world, player.getName(), permission);
    }

    public boolean playerAdd(Player player, String permission) {
        return this.playerAdd(player.getWorld().getName(), (OfflinePlayer)player, permission);
    }

    public boolean playerAddTransient(OfflinePlayer player, String permission) {
        Player online;
        return player instanceof Player && this.playerAddTransient(online = (Player)player, permission);
    }

    public boolean playerAddTransient(Player player, String permission) {
        for (PermissionAttachmentInfo paInfo : player.getEffectivePermissions()) {
            if (paInfo.getAttachment() == null || !paInfo.getAttachment().getPlugin().equals((Object)this.plugin)) continue;
            paInfo.getAttachment().setPermission(permission, true);
            return true;
        }
        PermissionAttachment attach = player.addAttachment(this.plugin);
        attach.setPermission(permission, true);
        return true;
    }

    public boolean playerAddTransient(@Nullable String worldName, OfflinePlayer player, String permission) {
        return this.playerAddTransient(player, permission);
    }

    public boolean playerAddTransient(@Nullable String worldName, Player player, String permission) {
        return this.playerAddTransient(player, permission);
    }

    public boolean playerRemoveTransient(@Nullable String worldName, OfflinePlayer player, String permission) {
        return this.playerRemoveTransient(player, permission);
    }

    public boolean playerRemoveTransient(@Nullable String worldName, Player player, String permission) {
        return this.playerRemoveTransient((OfflinePlayer)player, permission);
    }

    @Deprecated(since="1.4")
    public abstract boolean playerRemove(@Nullable String var1, String var2, String var3);

    public boolean playerRemove(@Nullable String world, OfflinePlayer player, String permission) {
        return player.getName() != null && this.playerRemove(world, player.getName(), permission);
    }

    @Deprecated
    public boolean playerRemove(@Nullable World world, String player, String permission) {
        return this.playerRemove(world != null ? world.getName() : null, player, permission);
    }

    public boolean playerRemove(Player player, String permission) {
        return this.playerRemove(player.getWorld().getName(), (OfflinePlayer)player, permission);
    }

    public boolean playerRemoveTransient(OfflinePlayer player, String permission) {
        Player online;
        return player instanceof Player && this.playerRemoveTransient(online = (Player)player, permission);
    }

    public boolean playerRemoveTransient(Player player, String permission) {
        for (PermissionAttachmentInfo paInfo : player.getEffectivePermissions()) {
            if (paInfo.getAttachment() == null || !paInfo.getAttachment().getPlugin().equals((Object)this.plugin)) continue;
            paInfo.getAttachment().unsetPermission(permission);
            return true;
        }
        return false;
    }

    public abstract boolean groupHas(@Nullable String var1, String var2, String var3);

    public boolean groupHas(@Nullable World world, String group, String permission) {
        return this.groupHas(world != null ? world.getName() : null, group, permission);
    }

    public abstract boolean groupAdd(@Nullable String var1, String var2, String var3);

    public boolean groupAdd(@Nullable World world, String group, String permission) {
        return this.groupAdd(world != null ? world.getName() : null, group, permission);
    }

    public abstract boolean groupRemove(@Nullable String var1, String var2, String var3);

    public boolean groupRemove(@Nullable World world, String group, String permission) {
        return this.groupRemove(world != null ? world.getName() : null, group, permission);
    }

    @Deprecated(since="1.4")
    public abstract boolean playerInGroup(@Nullable String var1, String var2, String var3);

    @Deprecated(since="1.4")
    public boolean playerInGroup(@Nullable World world, String player, String group) {
        return this.playerInGroup(world != null ? world.getName() : null, player, group);
    }

    public boolean playerInGroup(@Nullable String world, OfflinePlayer player, String group) {
        return player.getName() != null && this.playerInGroup(world, player.getName(), group);
    }

    public boolean playerInGroup(Player player, String group) {
        return this.playerInGroup(player.getWorld().getName(), (OfflinePlayer)player, group);
    }

    @Deprecated(since="1.4")
    public abstract boolean playerAddGroup(@Nullable String var1, String var2, String var3);

    @Deprecated(since="1.4")
    public boolean playerAddGroup(@Nullable World world, String player, String group) {
        return this.playerAddGroup(world != null ? world.getName() : null, player, group);
    }

    public boolean playerAddGroup(@Nullable String world, OfflinePlayer player, String group) {
        return player.getName() != null && this.playerAddGroup(world, player.getName(), group);
    }

    public boolean playerAddGroup(Player player, String group) {
        return this.playerAddGroup(player.getWorld().getName(), (OfflinePlayer)player, group);
    }

    @Deprecated(since="1.4")
    public abstract boolean playerRemoveGroup(@Nullable String var1, String var2, String var3);

    @Deprecated(since="1.4")
    public boolean playerRemoveGroup(@Nullable World world, String player, String group) {
        return this.playerRemoveGroup(world != null ? world.getName() : null, player, group);
    }

    public boolean playerRemoveGroup(@Nullable String world, OfflinePlayer player, String group) {
        return player.getName() != null && this.playerRemoveGroup(world, player.getName(), group);
    }

    public boolean playerRemoveGroup(Player player, String group) {
        return this.playerRemoveGroup(player.getWorld().getName(), (OfflinePlayer)player, group);
    }

    @Deprecated(since="1.4")
    public abstract String[] getPlayerGroups(@Nullable String var1, String var2);

    @Deprecated(since="1.4")
    public String[] getPlayerGroups(@Nullable World world, String player) {
        return this.getPlayerGroups(world != null ? world.getName() : null, player);
    }

    public String[] getPlayerGroups(@Nullable String world, OfflinePlayer player) {
        return this.getPlayerGroups(world, player.getName());
    }

    public String[] getPlayerGroups(Player player) {
        return this.getPlayerGroups(player.getWorld().getName(), (OfflinePlayer)player);
    }

    @Deprecated(since="1.4")
    public abstract String getPrimaryGroup(@Nullable String var1, String var2);

    @Deprecated(since="1.4")
    public String getPrimaryGroup(@Nullable World world, String player) {
        return this.getPrimaryGroup(world != null ? world.getName() : null, player);
    }

    public String getPrimaryGroup(@Nullable String world, OfflinePlayer player) {
        return this.getPrimaryGroup(world, player.getName());
    }

    public String getPrimaryGroup(Player player) {
        return this.getPrimaryGroup(player.getWorld().getName(), (OfflinePlayer)player);
    }

    public abstract String[] getGroups();

    public abstract boolean hasGroupSupport();
}

