/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.wrapper.service;

import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.milkbowl.vault.economy.Economy;
import net.thenextlvl.service.api.economy.Account;
import net.thenextlvl.service.api.economy.EconomyController;
import net.thenextlvl.service.wrapper.Wrapper;
import net.thenextlvl.service.wrapper.service.model.WrappedAccount;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class EconomyServiceWrapper
implements EconomyController,
Wrapper {
    private final Economy economy;
    private final Plugin provider;

    public EconomyServiceWrapper(Economy economy, Plugin provider) {
        this.economy = economy;
        this.provider = provider;
    }

    @Override
    public String format(Number amount) {
        return this.economy.format(amount.doubleValue());
    }

    @Override
    public String getCurrencyNamePlural(Locale locale) {
        return this.economy.currencyNamePlural();
    }

    @Override
    public String getCurrencyNameSingular(Locale locale) {
        return this.economy.currencyNameSingular();
    }

    @Override
    public String getCurrencySymbol() {
        return "";
    }

    @Override
    public CompletableFuture<@Unmodifiable Set<Account>> loadAccounts() {
        return CompletableFuture.completedFuture(this.getAccounts());
    }

    @Override
    public @Unmodifiable Set<Account> getAccounts() {
        return Arrays.stream(this.provider.getServer().getOfflinePlayers()).filter(this.economy::hasAccount).map(player -> new WrappedAccount(null, this.economy, (OfflinePlayer)player)).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Optional<Account> getAccount(OfflinePlayer player) {
        if (!this.economy.hasAccount(player)) {
            return Optional.empty();
        }
        return Optional.of(new WrappedAccount(null, this.economy, player));
    }

    @Override
    public Optional<Account> getAccount(OfflinePlayer player, World world) {
        if (!this.economy.hasAccount(player, world.getName())) {
            return Optional.empty();
        }
        return Optional.of(new WrappedAccount(world, this.economy, player));
    }

    @Override
    public Optional<Account> getAccount(UUID uuid) {
        return this.getAccount(this.provider.getServer().getOfflinePlayer(uuid));
    }

    @Override
    public Optional<Account> getAccount(UUID uuid, World world) {
        return this.getAccount(this.provider.getServer().getOfflinePlayer(uuid), world);
    }

    @Override
    public CompletableFuture<Account> createAccount(OfflinePlayer player) {
        return CompletableFuture.completedFuture(this.economy.createPlayerAccount(player)).thenApply(account -> this.getAccount(player).orElseThrow());
    }

    @Override
    public CompletableFuture<Account> createAccount(OfflinePlayer player, World world) {
        return CompletableFuture.completedFuture(this.economy.createPlayerAccount(player, world.getName())).thenApply(account -> this.getAccount(player, world).orElseThrow());
    }

    @Override
    public CompletableFuture<Account> createAccount(UUID uuid) {
        return this.createAccount(this.provider.getServer().getOfflinePlayer(uuid));
    }

    @Override
    public CompletableFuture<Account> createAccount(UUID uuid, World world) {
        return this.createAccount(this.provider.getServer().getOfflinePlayer(uuid), world);
    }

    @Override
    public CompletableFuture<Optional<Account>> loadAccount(OfflinePlayer player) {
        return CompletableFuture.completedFuture(this.getAccount(player));
    }

    @Override
    public CompletableFuture<Optional<Account>> loadAccount(OfflinePlayer player, World world) {
        return CompletableFuture.completedFuture(this.getAccount(player, world));
    }

    @Override
    public CompletableFuture<Optional<Account>> loadAccount(UUID uuid) {
        return this.loadAccount(this.provider.getServer().getOfflinePlayer(uuid));
    }

    @Override
    public CompletableFuture<Optional<Account>> loadAccount(UUID uuid, World world) {
        return this.loadAccount(this.provider.getServer().getOfflinePlayer(uuid), world);
    }

    @Override
    public CompletableFuture<Boolean> deleteAccount(UUID uuid) {
        return CompletableFuture.completedFuture(false);
    }

    @Override
    public CompletableFuture<Boolean> deleteAccount(UUID uuid, World world) {
        return CompletableFuture.completedFuture(false);
    }

    @Override
    public int fractionalDigits() {
        return this.economy.fractionalDigits();
    }

    @Override
    public Plugin getPlugin() {
        return this.provider;
    }

    @Override
    public String getName() {
        return this.economy.getName() + " Wrapper";
    }
}

