/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.placeholder.api;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import net.thenextlvl.service.ServicePlugin;
import net.thenextlvl.service.placeholder.api.PlaceholderStore;
import org.bukkit.OfflinePlayer;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class PlaceholderExpansionBuilder
extends PlaceholderExpansion {
    private final Set<PlaceholderStore<?>> stores = new HashSet();
    private final String identifier;
    private String author;
    private String version;
    protected final ServicePlugin plugin;

    public PlaceholderExpansionBuilder(ServicePlugin plugin, String identifier) {
        this.author = String.join((CharSequence)", ", plugin.getPluginMeta().getAuthors());
        this.version = plugin.getPluginMeta().getVersion();
        this.identifier = identifier;
        this.plugin = plugin;
    }

    public PlaceholderExpansionBuilder(ServicePlugin plugin) {
        this(plugin, "serviceio");
    }

    public final PlaceholderExpansionBuilder registerStore(PlaceholderStore<?> store) {
        if (store.isEnabled()) {
            this.stores.add(store);
        }
        return this;
    }

    public final PlaceholderExpansionBuilder setAuthors(Collection<String> authors) {
        this.author = String.join((CharSequence)", ", authors);
        return this;
    }

    public PlaceholderExpansionBuilder setVersion(String version) {
        this.version = version;
        return this;
    }

    public boolean canRegister() {
        return !this.stores.isEmpty() && super.canRegister();
    }

    public final String getIdentifier() {
        return this.identifier;
    }

    public final String getAuthor() {
        return this.author;
    }

    public String getVersion() {
        return this.version;
    }

    public final boolean persist() {
        return true;
    }

    public final @Nullable String onRequest(@Nullable OfflinePlayer player, String params) {
        return player == null ? null : (String)this.stores.stream().map(store -> store.resolve(player, params)).filter(Objects::nonNull).findAny().orElse(null);
    }
}

