/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.listener;

import net.citizensnpcs.api.event.NPCClickEvent;
import net.citizensnpcs.api.event.NPCDamageByEntityEvent;
import net.citizensnpcs.api.event.NPCDamageEvent;
import net.citizensnpcs.api.event.NPCLeftClickEvent;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import net.thenextlvl.service.api.character.CharacterController;
import net.thenextlvl.service.api.character.event.CharacterDamageEvent;
import net.thenextlvl.service.api.character.event.EntityDamageCharacterEvent;
import net.thenextlvl.service.api.character.event.PlayerInteractCharacterEvent;
import net.thenextlvl.service.model.character.citizens.CitizensCharacter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class CitizensListener
implements Listener {
    private final CharacterController controller;

    public CitizensListener(CharacterController controller) {
        this.controller = controller;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onNPCRightClick(NPCRightClickEvent event) {
        this.onNPCClick((NPCClickEvent)event, event.getClicker().isSneaking() ? PlayerInteractCharacterEvent.InteractionType.SHIFT_RIGHT_CLICK : PlayerInteractCharacterEvent.InteractionType.RIGHT_CLICK);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onNPCDamageByEntity(NPCDamageByEntityEvent event) {
        EntityDamageByEntityEvent cause = (EntityDamageByEntityEvent)event.getEvent();
        CitizensCharacter character = new CitizensCharacter(event.getNPC());
        EntityDamageCharacterEvent damageEvent = new EntityDamageCharacterEvent(this.controller, character, event.getDamager(), event.getCause(), event.getDamage(), cause.isCritical());
        damageEvent.setCancelled(event.isCancelled());
        event.setCancelled(!damageEvent.callEvent());
        event.setDamage(damageEvent.getDamage());
        Entity entity = event.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        NPCLeftClickEvent clickEvent = new NPCLeftClickEvent(event.getNPC(), player);
        clickEvent.setCancelled(event.isCancelled());
        this.onNPCClick((NPCClickEvent)clickEvent, event.getDamager().isSneaking() ? PlayerInteractCharacterEvent.InteractionType.SHIFT_LEFT_CLICK : PlayerInteractCharacterEvent.InteractionType.LEFT_CLICK);
        if (clickEvent.isCancelled()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onNPCDamage(NPCDamageEvent event) {
        CitizensCharacter character = new CitizensCharacter(event.getNPC());
        CharacterDamageEvent damageEvent = new CharacterDamageEvent(this.controller, character, event.getCause(), event.getDamage());
        damageEvent.setCancelled(event.isCancelled());
        event.setCancelled(!damageEvent.callEvent());
    }

    private void onNPCClick(NPCClickEvent event, PlayerInteractCharacterEvent.InteractionType type) {
        CitizensCharacter character = new CitizensCharacter(event.getNPC());
        PlayerInteractCharacterEvent characterEvent = new PlayerInteractCharacterEvent(this.controller, character, event.getClicker(), type);
        characterEvent.setCancelled(event.isCancelled());
        event.setCancelled(!characterEvent.callEvent());
    }
}

