/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.api.economy.bank;

import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.thenextlvl.service.api.Controller;
import net.thenextlvl.service.api.economy.bank.Bank;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public interface BankController
extends Controller {
    public String format(Number var1);

    public int fractionalDigits();

    default public CompletableFuture<Bank> createBank(OfflinePlayer player, String name) {
        return this.createBank(player.getUniqueId(), name);
    }

    default public CompletableFuture<Bank> createBank(OfflinePlayer player, String name, World world) {
        return this.createBank(player.getUniqueId(), name, world);
    }

    public CompletableFuture<Bank> createBank(UUID var1, String var2);

    public CompletableFuture<Bank> createBank(UUID var1, String var2, World var3);

    default public CompletableFuture<Bank> loadBank(OfflinePlayer player) {
        return this.loadBank(player.getUniqueId());
    }

    default public CompletableFuture<Bank> loadBank(OfflinePlayer player, World world) {
        return this.loadBank(player.getUniqueId(), world);
    }

    public CompletableFuture<Bank> loadBank(String var1);

    public CompletableFuture<Bank> loadBank(UUID var1);

    public CompletableFuture<Bank> loadBank(UUID var1, World var2);

    public CompletableFuture<@Unmodifiable Set<Bank>> loadBanks();

    public CompletableFuture<@Unmodifiable Set<Bank>> loadBanks(World var1);

    default public CompletableFuture<Bank> tryGetBank(String name) {
        return this.getBank(name).map(CompletableFuture::completedFuture).orElseGet(() -> this.loadBank(name));
    }

    default public CompletableFuture<Bank> tryGetBank(OfflinePlayer player) {
        return this.getBank(player).map(CompletableFuture::completedFuture).orElseGet(() -> this.loadBank(player));
    }

    default public CompletableFuture<Bank> tryGetBank(OfflinePlayer player, World world) {
        return this.getBank(player, world).map(CompletableFuture::completedFuture).orElseGet(() -> this.loadBank(player, world));
    }

    default public CompletableFuture<Bank> tryGetBank(UUID uuid) {
        return this.getBank(uuid).map(CompletableFuture::completedFuture).orElseGet(() -> this.loadBank(uuid));
    }

    default public CompletableFuture<Bank> tryGetBank(UUID uuid, World world) {
        return this.getBank(uuid, world).map(CompletableFuture::completedFuture).orElseGet(() -> this.loadBank(uuid, world));
    }

    default public CompletableFuture<Boolean> deleteBank(Bank bank) {
        return bank.getWorld().map(world -> this.deleteBank(bank.getOwner(), (World)world)).orElseGet(() -> this.deleteBank(bank.getOwner()));
    }

    default public CompletableFuture<Boolean> deleteBank(OfflinePlayer player) {
        return this.deleteBank(player.getUniqueId());
    }

    default public CompletableFuture<Boolean> deleteBank(OfflinePlayer player, World world) {
        return this.deleteBank(player.getUniqueId(), world);
    }

    public CompletableFuture<Boolean> deleteBank(String var1);

    public CompletableFuture<Boolean> deleteBank(UUID var1);

    public CompletableFuture<Boolean> deleteBank(UUID var1, World var2);

    public @Unmodifiable Set<Bank> getBanks();

    public @Unmodifiable Set<Bank> getBanks(World var1);

    public Optional<Bank> getBank(String var1);

    default public Optional<Bank> getBank(OfflinePlayer player) {
        return this.getBank(player.getUniqueId());
    }

    default public Optional<Bank> getBank(OfflinePlayer player, World world) {
        return this.getBank(player.getUniqueId(), world);
    }

    public Optional<Bank> getBank(UUID var1);

    public Optional<Bank> getBank(UUID var1, World var2);
}

