/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.api.chat;

import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.thenextlvl.service.api.Controller;
import net.thenextlvl.service.api.chat.ChatProfile;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.jspecify.annotations.NullMarked;

@NullMarked
public interface ChatController
extends Controller {
    default public CompletableFuture<ChatProfile> loadProfile(OfflinePlayer player) {
        return this.loadProfile(player.getUniqueId());
    }

    default public CompletableFuture<ChatProfile> loadProfile(OfflinePlayer player, World world) {
        return this.loadProfile(player.getUniqueId(), world);
    }

    public CompletableFuture<ChatProfile> loadProfile(UUID var1);

    public CompletableFuture<ChatProfile> loadProfile(UUID var1, World var2);

    default public CompletableFuture<ChatProfile> tryGetProfile(OfflinePlayer player) {
        return this.getProfile(player).map(CompletableFuture::completedFuture).orElseGet(() -> this.loadProfile(player));
    }

    default public CompletableFuture<ChatProfile> tryGetProfile(OfflinePlayer player, World world) {
        return this.getProfile(player, world).map(CompletableFuture::completedFuture).orElseGet(() -> this.loadProfile(player, world));
    }

    default public CompletableFuture<ChatProfile> tryGetProfile(UUID uuid) {
        return this.getProfile(uuid).map(CompletableFuture::completedFuture).orElseGet(() -> this.loadProfile(uuid));
    }

    default public CompletableFuture<ChatProfile> tryGetProfile(UUID uuid, World world) {
        return this.getProfile(uuid, world).map(CompletableFuture::completedFuture).orElseGet(() -> this.loadProfile(uuid, world));
    }

    default public Optional<ChatProfile> getProfile(OfflinePlayer player) {
        return this.getProfile(player.getUniqueId());
    }

    default public Optional<ChatProfile> getProfile(OfflinePlayer player, World world) {
        return this.getProfile(player.getUniqueId(), world);
    }

    public Optional<ChatProfile> getProfile(UUID var1);

    public Optional<ChatProfile> getProfile(UUID var1, World var2);
}

