/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service;

import core.i18n.file.ComponentBundle;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Function;
import net.kyori.adventure.key.Key;
import net.milkbowl.vault.Vault;
import net.thenextlvl.service.api.Controller;
import net.thenextlvl.service.api.character.CharacterController;
import net.thenextlvl.service.api.chat.ChatController;
import net.thenextlvl.service.api.economy.EconomyController;
import net.thenextlvl.service.api.economy.bank.BankController;
import net.thenextlvl.service.api.group.GroupController;
import net.thenextlvl.service.api.hologram.HologramController;
import net.thenextlvl.service.api.permission.PermissionController;
import net.thenextlvl.service.command.ServiceCommand;
import net.thenextlvl.service.controller.permission.SuperPermsPermissionController;
import net.thenextlvl.service.listener.PluginListener;
import net.thenextlvl.service.listener.ServiceListener;
import net.thenextlvl.service.version.PluginVersionChecker;
import net.thenextlvl.services.bstats.bukkit.Metrics;
import net.thenextlvl.services.bstats.charts.SimplePie;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class ServicePlugin
extends Vault {
    private final PluginVersionChecker versionChecker = new PluginVersionChecker((Plugin)this);
    private final Metrics metrics = new Metrics((Plugin)this, 23083);
    private final Key key = Key.key((String)"service_io", (String)"translations");
    private final Path translations = this.getDataPath().resolve("translations");
    private final ComponentBundle bundle = ComponentBundle.builder(this.key, this.translations).placeholder("prefix", "prefix").resource("service-io.properties", Locale.US).resource("service-io_german.properties", Locale.GERMANY).build();

    public void onLoad() {
        this.versionChecker.checkVersion();
        this.registerServices();
        this.registerCommands();
    }

    public void onEnable() {
        this.registerListeners();
        this.addCustomCharts();
    }

    public void onDisable() {
        this.metrics.shutdown();
    }

    private void registerServices() {
        this.getServer().getServicesManager().register(PermissionController.class, (Object)new SuperPermsPermissionController(this), (Plugin)this, ServicePriority.Lowest);
        this.getComponentLogger().debug("Added SuperPerms as backup permission provider (Lowest)");
    }

    private void registerListeners() {
        this.getServer().getPluginManager().registerEvents((Listener)new ServiceListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PluginListener(this), (Plugin)this);
    }

    private void registerCommands() {
        this.getLifecycleManager().registerEventHandler(LifecycleEvents.COMMANDS.newHandler(event -> ((Commands)event.registrar()).register(ServiceCommand.create(this))));
    }

    public ComponentBundle bundle() {
        return this.bundle;
    }

    private void addCustomCharts() {
        this.addCustomChart(BankController.class, Controller::getName, "bank_provider");
        this.addCustomChart(GroupController.class, Controller::getName, "group_provider");
        this.addCustomChart(ChatController.class, Controller::getName, "chat_provider");
        this.addCustomChart(EconomyController.class, Controller::getName, "economy_provider");
        this.addCustomChart(PermissionController.class, Controller::getName, "permission_provider");
        this.addCustomChart(HologramController.class, Controller::getName, "hologram_provider");
        this.addCustomChart(CharacterController.class, Controller::getName, "npc_provider");
    }

    private <T> void addCustomChart(Class<T> service, Function<T, String> function, String chartId) {
        Object loaded = this.getServer().getServicesManager().load(service);
        this.metrics.addCustomChart(new SimplePie(chartId, () -> loaded != null ? (String)function.apply(loaded) : "None"));
    }

    public EntityType getEntityTypeByClass(Class<? extends Entity> type) {
        return Arrays.stream(EntityType.values()).filter(entityType -> type.equals(entityType.getEntityClass())).findAny().orElseThrow();
    }
}

