/*
 * Decompiled with CFR 0.152.
 */
package core.version.modrinth;

import com.google.gson.Gson;
import core.version.Version;
import core.version.VersionChecker;
import core.version.modrinth.ModrinthVersion;
import core.version.modrinth.ModrinthVersions;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.jspecify.annotations.NullMarked;

@NullMarked
public abstract class ModrinthVersionChecker<V extends Version>
implements VersionChecker<ModrinthVersion, V> {
    private static final String API_URL = "https://api.modrinth.com/v2/project/%s/";
    private static final HttpClient client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).build();
    private static final Gson gson = new Gson();
    private Set<ModrinthVersion> versions = new HashSet<ModrinthVersion>();
    private final String id;

    public ModrinthVersionChecker(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public CompletableFuture<V> retrieveLatestVersion() {
        return ((CompletableFuture)this.retrieveModrinthVersions().thenApply(versions -> {
            List modrinthVersions = List.copyOf(versions);
            ModrinthVersion version = (ModrinthVersion)modrinthVersions.getFirst();
            return version.versionNumber();
        })).thenApply(this::parseVersion);
    }

    @Override
    public CompletableFuture<Set<V>> retrieveVersions() {
        return this.retrieveModrinthVersions().thenApply(versions -> versions.stream().map(this::parseVersion).collect(Collectors.toUnmodifiableSet()));
    }

    @Override
    public CompletableFuture<Optional<V>> retrieveLatestSupportedVersion() {
        return this.retrieveModrinthVersions().thenApply(versions -> versions.stream().filter(this::isSupported).map(this::parseVersion).max(Comparable::compareTo));
    }

    @Override
    public Set<V> getSupportedVersions() {
        return this.versions.stream().filter(this::isSupported).map(this::parseVersion).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Set<V> getVersions() {
        return this.versions.stream().map(this::parseVersion).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Optional<V> getLatestSupportedVersion() {
        return this.versions.stream().filter(this::isSupported).map(this::parseVersion).max(Comparable::compareTo);
    }

    @Override
    public Optional<V> getLatestVersion() {
        return this.versions.stream().map(this::parseVersion).max(Comparable::compareTo);
    }

    @Override
    public V parseVersion(ModrinthVersion version) {
        return this.parseVersion(version.name());
    }

    public final CompletableFuture<Set<ModrinthVersion>> retrieveModrinthVersions() {
        return this.get("version").thenApply(response -> {
            this.versions = Objects.requireNonNullElse((Set)gson.fromJson((String)response.body(), ModrinthVersions.class), this.versions);
            return this.versions;
        });
    }

    private CompletableFuture<HttpResponse<String>> get(String path) {
        return client.sendAsync(HttpRequest.newBuilder().uri(URI.create(API_URL.formatted(this.getId()) + path)).build(), HttpResponse.BodyHandlers.ofString());
    }
}

