/*
 * Decompiled with CFR 0.152.
 */
package core.paper.gui;

import core.paper.gui.AbstractGUI;
import core.paper.item.ActionItem;
import core.paper.item.ItemBuilder;
import java.util.List;
import java.util.stream.IntStream;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class GUI<P extends Plugin>
extends AbstractGUI
implements Listener {
    protected final P plugin;
    private final Inventory inventory;
    private final int size;
    private boolean passUnknownClickTypes;

    public GUI(P plugin, Player owner, Component title, int rows) {
        super(owner, title);
        this.plugin = plugin;
        this.size = rows * 9;
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)this.getSize(), (Component)this.title());
        Bukkit.getPluginManager().registerEvents((Listener)this, plugin);
        this.formatDefault();
    }

    protected void formatDefault() {
        ItemBuilder placeholder1 = ItemBuilder.of(Material.GRAY_STAINED_GLASS_PANE).hideTooltip();
        ItemBuilder placeholder2 = ItemBuilder.of(Material.WHITE_STAINED_GLASS_PANE).hideTooltip();
        List<Integer> stream = IntStream.of(0, 8, this.getSize() - 1, this.getSize() - 9).boxed().toList();
        IntStream.range(0, this.getSize()).filter(value -> !stream.contains(value)).forEach(slot -> this.setSlotIfAbsent(slot, placeholder1));
        stream.forEach(slot -> this.setSlotIfAbsent((int)slot, placeholder2));
    }

    protected void onClose() {
    }

    protected void onOpen() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(priority=EventPriority.HIGHEST)
    public final void onInventoryClick(InventoryClickEvent event) {
        if (!this.equals(event.getInventory().getHolder())) {
            return;
        }
        if (event.getInventory().equals((Object)this.getInventory())) {
            try {
                if (event.getClick().equals((Object)ClickType.UNKNOWN) && !this.isPassUnknownClickTypes()) {
                    return;
                }
                if (!event.getInventory().equals((Object)event.getClickedInventory())) {
                    return;
                }
                HumanEntity humanEntity = event.getWhoClicked();
                if (!(humanEntity instanceof Player)) {
                    return;
                }
                Player player = (Player)humanEntity;
                ActionItem.Action action = this.getActions().get(event.getSlot());
                if (action != null) {
                    action.click(event.getClick(), event.getHotbarButton(), player);
                }
            }
            catch (Exception e) {
                this.plugin.getComponentLogger().error("Something went wrong while handling a gui interaction", (Throwable)e);
            }
            finally {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onInventoryOpen(InventoryOpenEvent event) {
        if (!this.equals(event.getInventory().getHolder())) {
            return;
        }
        if (!event.getInventory().equals((Object)this.getInventory())) {
            return;
        }
        if (!event.getPlayer().equals((Object)this.getOwner())) {
            this.plugin.getComponentLogger().warn("Tried to open GUI for unauthorized player");
            event.setCancelled(true);
        } else {
            this.onOpen();
            event.titleOverride(this.title());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public final void onInventoryClose(InventoryCloseEvent event) {
        if (!this.equals(event.getInventory().getHolder())) {
            return;
        }
        if (!event.getInventory().equals((Object)this.getInventory())) {
            return;
        }
        HandlerList.unregisterAll((Listener)this);
        this.onClose();
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public boolean isPassUnknownClickTypes() {
        return this.passUnknownClickTypes;
    }

    public void setPassUnknownClickTypes(boolean passUnknownClickTypes) {
        this.passUnknownClickTypes = passUnknownClickTypes;
    }

    public int getSize() {
        return this.size;
    }
}

