/*
 * Decompiled with CFR 0.152.
 */
package core.paper.command.argument;

import com.mojang.brigadier.arguments.ArgumentType;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.CustomArgumentType;
import io.papermc.paper.util.Tick;
import java.time.Duration;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class DurationArgumentType
implements CustomArgumentType.Converted<Duration, Integer> {
    private final Duration minimum;

    private DurationArgumentType(Duration minimum) {
        this.minimum = minimum;
    }

    @Contract(value=" -> new", pure=true)
    public static DurationArgumentType duration() {
        return DurationArgumentType.duration(Duration.ZERO);
    }

    @Contract(value="_ -> new", pure=true)
    public static DurationArgumentType duration(Duration minimum) {
        return new DurationArgumentType(minimum);
    }

    public Duration convert(Integer nativeType) {
        return Tick.of((long)nativeType.intValue());
    }

    public ArgumentType<Integer> getNativeType() {
        return ArgumentTypes.time((int)Tick.tick().fromDuration(this.minimum));
    }
}

