/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.wrapper.service;

import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import net.thenextlvl.service.api.economy.bank.Bank;
import net.thenextlvl.service.api.economy.bank.BankController;
import net.thenextlvl.service.wrapper.Wrapper;
import net.thenextlvl.service.wrapper.service.model.WrappedBank;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class BankServiceWrapper
implements BankController,
Wrapper {
    private final Economy economy;
    private final Plugin provider;

    public BankServiceWrapper(Economy economy, Plugin provider) {
        this.economy = economy;
        this.provider = provider;
    }

    @Override
    public String format(Number amount) {
        return this.economy.format(amount.doubleValue());
    }

    @Override
    public int fractionalDigits() {
        return this.economy.fractionalDigits();
    }

    @Override
    public CompletableFuture<Bank> createBank(OfflinePlayer player, String name) {
        return CompletableFuture.completedFuture(this.economy.createBank(name, player)).thenApply(bank -> this.getBank(name).orElseThrow());
    }

    @Override
    public CompletableFuture<Bank> createBank(OfflinePlayer player, String name, World world) {
        return this.createBank(player, name);
    }

    @Override
    public CompletableFuture<Bank> createBank(UUID uuid, String name) {
        return this.createBank(this.provider.getServer().getOfflinePlayer(uuid), name);
    }

    @Override
    public CompletableFuture<Bank> createBank(UUID uuid, String name, World world) {
        return this.createBank(this.provider.getServer().getOfflinePlayer(uuid), name, world);
    }

    @Override
    public CompletableFuture<Bank> loadBank(String name) {
        return CompletableFuture.completedFuture(this.getBank(name).orElse(null));
    }

    @Override
    public CompletableFuture<Bank> loadBank(UUID uuid) {
        return CompletableFuture.completedFuture(this.getBank(uuid).orElse(null));
    }

    @Override
    public CompletableFuture<Bank> loadBank(UUID uuid, World world) {
        return CompletableFuture.completedFuture(this.getBank(uuid, world).orElse(null));
    }

    @Override
    public CompletableFuture<@Unmodifiable Set<Bank>> loadBanks() {
        return CompletableFuture.completedFuture(this.getBanks());
    }

    @Override
    public CompletableFuture<@Unmodifiable Set<Bank>> loadBanks(World world) {
        return CompletableFuture.completedFuture(this.getBanks(world));
    }

    @Override
    public CompletableFuture<Boolean> deleteBank(String name) {
        return CompletableFuture.completedFuture(this.economy.deleteBank(name)).thenApply(EconomyResponse::transactionSuccess);
    }

    @Override
    public CompletableFuture<Boolean> deleteBank(UUID uuid) {
        return this.deleteBank(this.getBank(uuid).orElseThrow().getName());
    }

    @Override
    public CompletableFuture<Boolean> deleteBank(UUID uuid, World world) {
        return this.deleteBank(this.getBank(uuid, world).orElseThrow().getName());
    }

    @Override
    public @Unmodifiable Set<Bank> getBanks() {
        return this.economy.getBanks().stream().map(bank -> new WrappedBank((String)bank, null, this.economy, this.provider)).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public @Unmodifiable Set<Bank> getBanks(World world) {
        return this.getBanks();
    }

    @Override
    public Optional<Bank> getBank(String name) {
        return Optional.of(new WrappedBank(name, null, this.economy, this.provider));
    }

    @Override
    public Optional<Bank> getBank(UUID uuid) {
        return Optional.empty();
    }

    @Override
    public Optional<Bank> getBank(UUID uuid, World world) {
        return Optional.empty();
    }

    @Override
    public Plugin getPlugin() {
        return this.provider;
    }

    @Override
    public String getName() {
        return this.economy.getName() + " Wrapper";
    }
}

