/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.placeholder.economy;

import java.util.UUID;
import java.util.regex.Matcher;
import net.milkbowl.vault2.economy.AccountPermission;
import net.milkbowl.vault2.economy.Economy;
import net.thenextlvl.service.ServicePlugin;
import net.thenextlvl.service.placeholder.api.PlaceholderResolver;
import net.thenextlvl.service.placeholder.api.PlaceholderStore;
import org.bukkit.OfflinePlayer;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class UnlockedEconomyPlaceholderStore
extends PlaceholderStore<Economy> {
    private static final String PLUGIN_NAME = "VaultUnlocked";

    public UnlockedEconomyPlaceholderStore(ServicePlugin plugin) {
        super(plugin, Economy.class);
    }

    @Override
    protected void registerResolvers(Economy provider) {
        this.registerResolver("balance_currency_%s", (OfflinePlayer player, Matcher matcher) -> {
            String currency = this.decode(matcher.group(1));
            return provider.balance(PLUGIN_NAME, player.getUniqueId(), "world", currency).toPlainString();
        });
        this.registerResolver("balance_currency_%s_world_%s", (OfflinePlayer player, Matcher matcher) -> {
            String currency = this.decode(matcher.group(1));
            String world = matcher.group(2);
            return provider.balance(PLUGIN_NAME, player.getUniqueId(), world, currency).toPlainString();
        });
        this.registerResolver("balance_%s", (OfflinePlayer player, Matcher matcher) -> {
            String world = matcher.group(1);
            return provider.balance(PLUGIN_NAME, player.getUniqueId(), world).toPlainString();
        });
        this.registerResolver("balance", (OfflinePlayer player, Matcher matcher) -> provider.balance(PLUGIN_NAME, player.getUniqueId()).toPlainString());
        this.registerResolver("balanceformatted_currency_%s", (OfflinePlayer player, Matcher matcher) -> {
            String currency = this.decode(matcher.group(1));
            return provider.format(PLUGIN_NAME, provider.balance(PLUGIN_NAME, player.getUniqueId(), "world", currency));
        });
        this.registerResolver("balanceformatted_currency_%s_world_%s", (OfflinePlayer player, Matcher matcher) -> {
            String currency = this.decode(matcher.group(1));
            String world = matcher.group(2);
            return provider.format(PLUGIN_NAME, provider.balance(PLUGIN_NAME, player.getUniqueId(), world, currency));
        });
        this.registerResolver("balanceformatted_%s", (OfflinePlayer player, Matcher matcher) -> {
            String world = matcher.group(1);
            return provider.format(PLUGIN_NAME, provider.balance(PLUGIN_NAME, player.getUniqueId(), world));
        });
        this.registerResolver("balanceformatted", (OfflinePlayer player, Matcher matcher) -> provider.format(PLUGIN_NAME, provider.balance(PLUGIN_NAME, player.getUniqueId())));
        this.registerResolver("account_%s", PlaceholderResolver.throwing((player, matcher) -> {
            UUID accountId = UUID.fromString(matcher.group(1));
            return provider.balance(PLUGIN_NAME, accountId).toPlainString();
        }, IllegalArgumentException.class));
        this.registerResolver("account_%s_currency_%s", PlaceholderResolver.throwing((player, matcher) -> {
            UUID accountId = UUID.fromString(matcher.group(1));
            String currency = this.decode(matcher.group(2));
            return provider.balance(PLUGIN_NAME, accountId, "world", currency).toPlainString();
        }, IllegalArgumentException.class));
        this.registerResolver("account_%s_currency_%s_formatted", PlaceholderResolver.throwing((player, matcher) -> {
            UUID accountId = UUID.fromString(matcher.group(1));
            String currency = this.decode(matcher.group(2));
            return provider.format(PLUGIN_NAME, provider.balance(PLUGIN_NAME, accountId, "world", currency));
        }, IllegalArgumentException.class));
        this.registerResolver("account_%s_currency_%s_world_%s", PlaceholderResolver.throwing((player, matcher) -> {
            UUID accountId = UUID.fromString(matcher.group(1));
            String currency = this.decode(matcher.group(2));
            String world = matcher.group(3);
            return provider.balance(PLUGIN_NAME, accountId, world, currency).toPlainString();
        }, IllegalArgumentException.class));
        this.registerResolver("account_%s_currency_%s_world_%s", PlaceholderResolver.throwing((player, matcher) -> {
            UUID accountId = UUID.fromString(matcher.group(1));
            String currency = this.decode(matcher.group(2));
            String world = matcher.group(3);
            return provider.format(PLUGIN_NAME, provider.balance(PLUGIN_NAME, accountId, world, currency));
        }, IllegalArgumentException.class));
        this.registerResolver("can_%s_%s", PlaceholderResolver.throwing((player, matcher) -> {
            AccountPermission permission;
            UUID accountId = UUID.fromString(matcher.group(2));
            switch (matcher.group(1)) {
                case "deposit": {
                    AccountPermission accountPermission = AccountPermission.DEPOSIT;
                    break;
                }
                case "withdraw": {
                    AccountPermission accountPermission = AccountPermission.WITHDRAW;
                    break;
                }
                case "balance": {
                    AccountPermission accountPermission = AccountPermission.BALANCE;
                    break;
                }
                case "transfer": {
                    AccountPermission accountPermission = AccountPermission.TRANSFER_OWNERSHIP;
                    break;
                }
                case "invite": {
                    AccountPermission accountPermission = AccountPermission.INVITE_MEMBER;
                    break;
                }
                case "remove": {
                    AccountPermission accountPermission = AccountPermission.REMOVE_MEMBER;
                    break;
                }
                case "modify": {
                    AccountPermission accountPermission = AccountPermission.CHANGE_MEMBER_PERMISSION;
                    break;
                }
                case "delete": {
                    AccountPermission accountPermission = AccountPermission.DELETE;
                    break;
                }
                default: {
                    AccountPermission accountPermission = permission = null;
                }
            }
            if (permission == null) {
                return null;
            }
            return provider.hasAccountPermission(PLUGIN_NAME, accountId, player.getUniqueId(), permission) ? "yes" : "no";
        }, IllegalArgumentException.class));
        this.registerResolver("accounts", (OfflinePlayer player, Matcher matcher) -> String.join((CharSequence)", ", provider.accountsMemberOf(PLUGIN_NAME, player.getUniqueId())));
        this.registerResolver("accounts_count", (OfflinePlayer player, Matcher matcher) -> String.valueOf(provider.accountsMemberOf(PLUGIN_NAME, player.getUniqueId()).size()));
        this.registerResolver("currency", (OfflinePlayer uuid, Matcher params) -> provider.defaultCurrencyNameSingular(PLUGIN_NAME));
        this.registerResolver("currencyplural", (OfflinePlayer uuid, Matcher params) -> provider.defaultCurrencyNamePlural(PLUGIN_NAME));
    }

    private String decode(String input) {
        return input.replace("%20", " ").replace("%24", "$").replace("%2B", "+").replace("%26", "&").replace("%2F", "/").replace("%3D", "=");
    }
}

