/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.placeholder.economy;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import net.thenextlvl.service.ServicePlugin;
import net.thenextlvl.service.api.economy.Account;
import net.thenextlvl.service.api.economy.EconomyController;
import net.thenextlvl.service.placeholder.api.PlaceholderStore;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class ServiceEconomyPlaceholderStore
extends PlaceholderStore<EconomyController> {
    public ServiceEconomyPlaceholderStore(ServicePlugin plugin) {
        super(plugin, EconomyController.class);
    }

    @Override
    protected void registerResolvers(EconomyController provider) {
        this.registerResolver("balance", (OfflinePlayer player, Matcher matcher) -> provider.getAccount(player).map(Account::getBalance).orElse(BigDecimal.ZERO).toPlainString());
        this.registerResolver("balance_%s", (OfflinePlayer player, Matcher matcher) -> {
            World world = this.plugin.getServer().getWorld(matcher.group(1));
            if (world == null) {
                return null;
            }
            return provider.getAccount(player, world).map(Account::getBalance).orElse(BigDecimal.ZERO).toPlainString();
        });
        this.registerResolver("balance_formatted", (OfflinePlayer player, Matcher matcher) -> provider.format(provider.getAccount(player).map(Account::getBalance).orElse(BigDecimal.ZERO)));
        this.registerResolver("balance_formatted_%s", (OfflinePlayer player, Matcher matcher) -> {
            World world = this.plugin.getServer().getWorld(matcher.group(1));
            if (world == null) {
                return null;
            }
            return provider.format(provider.getAccount(player, world).map(Account::getBalance).orElse(BigDecimal.ZERO));
        });
    }
}

