/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.placeholder.api;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.thenextlvl.service.ServicePlugin;
import net.thenextlvl.service.placeholder.api.PlaceholderResolver;
import org.bukkit.OfflinePlayer;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public abstract class PlaceholderStore<T> {
    private final Map<Pattern, PlaceholderResolver> resolvers = new HashMap<Pattern, PlaceholderResolver>();
    private final @Nullable T provider;
    protected final ServicePlugin plugin;

    public PlaceholderStore(ServicePlugin plugin, Class<T> providerClass) {
        this.plugin = plugin;
        this.provider = plugin.getServer().getServicesManager().load(providerClass);
        if (this.provider == null) {
            return;
        }
        this.registerResolvers(this.provider);
        plugin.getComponentLogger().info("Registered placeholders for {} ({})", (Object)this.provider.getClass().getSimpleName(), (Object)providerClass.getSimpleName());
    }

    public final void registerResolver(Pattern pattern, PlaceholderResolver resolver) {
        this.resolvers.put(pattern, resolver);
    }

    protected final void registerResolver(String regex, PlaceholderResolver resolver) {
        this.resolvers.put(Pattern.compile(regex.replace("%s", "([^{}_]+)")), resolver);
    }

    protected abstract void registerResolvers(T var1);

    public final @Nullable String resolve(OfflinePlayer player, String params) {
        try {
            for (Map.Entry<Pattern, PlaceholderResolver> entry : this.resolvers.entrySet()) {
                Matcher matcher = entry.getKey().matcher(params);
                if (!matcher.matches()) continue;
                return entry.getValue().resolve(player, matcher);
            }
            return null;
        }
        catch (Exception e) {
            String name = player.getName() != null ? player.getName() : player.getUniqueId().toString();
            this.plugin.getComponentLogger().warn("Failed to resolve placeholder '{}' for player {}", new Object[]{params, name, e});
            return null;
        }
    }

    public final boolean isEnabled() {
        return this.provider != null;
    }
}

