/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.model.permission;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kyori.adventure.util.TriState;
import net.thenextlvl.service.api.group.GroupHolder;
import net.thenextlvl.service.model.group.GroupManagerGroup;
import org.anjocaido.groupmanager.data.Group;
import org.anjocaido.groupmanager.data.User;
import org.anjocaido.groupmanager.dataholder.WorldDataHolder;
import org.anjocaido.groupmanager.permissions.AnjoPermissionsHandler;
import org.anjocaido.groupmanager.utils.PermissionCheckResult;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public record GroupManagerPermissionHolder(User user, WorldDataHolder holder) implements GroupHolder
{
    @Override
    public @Unmodifiable Map<String, Boolean> getPermissions() {
        return this.user().getPermissionList().stream().collect(Collectors.toUnmodifiableMap(permission -> permission, permission -> this.checkPermission((String)permission).toBooleanOrElse(false)));
    }

    @Override
    public TriState checkPermission(String permission) {
        return switch (this.holder().getPermissionsHandler().checkFullUserPermission((User)this.user(), (String)permission).resultType) {
            case PermissionCheckResult.Type.FOUND -> TriState.TRUE;
            case PermissionCheckResult.Type.NEGATION, PermissionCheckResult.Type.EXCEPTION -> TriState.FALSE;
            default -> TriState.NOT_SET;
        };
    }

    @Override
    public boolean addPermission(String permission) {
        return this.setPermission(permission, true);
    }

    @Override
    public boolean removePermission(String permission) {
        return this.user().removePermission(permission);
    }

    @Override
    public boolean setPermission(String permission, boolean value) {
        Boolean state = this.checkPermission(permission).toBoolean();
        if (state != null && state.equals(value)) {
            return false;
        }
        this.removePermission((String)(value ? "-" + permission : permission));
        this.user().addPermission((String)(!value ? "-" + permission : permission));
        return true;
    }

    @Override
    public <T> Optional<T> getInfoNode(String key, Function<@Nullable String, @Nullable T> mapper) {
        return Optional.ofNullable(mapper.apply(this.user().getVariables().getVarString(key)));
    }

    @Override
    public boolean removeInfoNode(String key) {
        if (!this.hasInfoNode(key)) {
            return false;
        }
        this.user().getVariables().removeVar(key);
        return true;
    }

    @Override
    public boolean setInfoNode(String key, String value) {
        this.user().getVariables().addVar(key, (Object)value);
        return true;
    }

    @Override
    public boolean hasInfoNode(String key) {
        return this.user().getVariables().hasVar(key);
    }

    @Override
    public @Unmodifiable Set<net.thenextlvl.service.api.group.Group> getGroups() {
        return this.holder.getGroups().values().stream().filter(group -> this.inGroup(group.getName())).map(GroupManagerGroup::new).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public String getPrimaryGroup() {
        return this.user().getGroupName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean addGroup(net.thenextlvl.service.api.group.Group group) {
        Group managerGroup;
        if (!(group instanceof GroupManagerGroup)) return this.addGroup(group.getName());
        GroupManagerGroup groupManagerGroup = (GroupManagerGroup)group;
        try {
            Group group2;
            managerGroup = group2 = groupManagerGroup.group();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return this.user().addSubGroup(managerGroup);
    }

    @Override
    public boolean addGroup(String name) {
        Group group = this.holder().getGroup(name);
        return group != null && this.user().addSubGroup(group);
    }

    @Override
    public boolean inGroup(net.thenextlvl.service.api.group.Group group) {
        return this.inGroup(group.getName());
    }

    @Override
    public boolean inGroup(String name) {
        AnjoPermissionsHandler handler = this.holder().getPermissionsHandler();
        return handler.hasGroupInInheritance(this.user().getGroup(), name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean removeGroup(net.thenextlvl.service.api.group.Group group) {
        Group managerGroup;
        if (!(group instanceof GroupManagerGroup)) return this.removeGroup(group.getName());
        GroupManagerGroup groupManagerGroup = (GroupManagerGroup)group;
        try {
            Group group2;
            managerGroup = group2 = groupManagerGroup.group();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return this.user().removeSubGroup(managerGroup);
    }

    @Override
    public boolean removeGroup(String name) {
        Group group = this.holder().getGroup(name);
        return group != null && this.user().removeSubGroup(group);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setPrimaryGroup(net.thenextlvl.service.api.group.Group group) {
        Group managerGroup;
        if (!(group instanceof GroupManagerGroup)) return this.setPrimaryGroup(group.getName());
        GroupManagerGroup groupManagerGroup = (GroupManagerGroup)group;
        try {
            Group group2;
            managerGroup = group2 = groupManagerGroup.group();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        this.user().setGroup(managerGroup, Boolean.valueOf(true));
        return true;
    }

    @Override
    public boolean setPrimaryGroup(String name) {
        Group group = this.holder().getGroup(name);
        if (group != null) {
            this.user().setGroup(group, Boolean.valueOf(true));
        }
        return group != null;
    }
}

