/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.model.group;

import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import net.kyori.adventure.util.TriState;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.model.data.DataMutateResult;
import net.luckperms.api.model.group.Group;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.types.DisplayNameNode;
import net.luckperms.api.node.types.MetaNode;
import net.luckperms.api.node.types.PrefixNode;
import net.luckperms.api.node.types.SuffixNode;
import net.luckperms.api.node.types.WeightNode;
import net.luckperms.api.query.QueryOptions;
import net.luckperms.api.util.Tristate;
import org.bukkit.World;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public record LuckPermsGroup(Group group, QueryOptions options, @Nullable World world) implements net.thenextlvl.service.api.group.Group
{
    @Override
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(this.group().getDisplayName(this.options()));
    }

    @Override
    public Optional<String> getPrefix() {
        return Optional.ofNullable(this.group().getCachedData().getMetaData(this.options()).getPrefix());
    }

    @Override
    public Optional<String> getPrefix(int priority) {
        return Optional.ofNullable(this.getPrefixes().get(priority));
    }

    @Override
    public @Unmodifiable Map<Integer, String> getPrefixes() {
        return this.group().getCachedData().getMetaData(this.options()).getPrefixes();
    }

    @Override
    public Optional<String> getSuffix() {
        return Optional.ofNullable(this.group().getCachedData().getMetaData(this.options()).getSuffix());
    }

    @Override
    public Optional<String> getSuffix(int priority) {
        return Optional.ofNullable(this.getSuffixes().get(priority));
    }

    @Override
    public @Unmodifiable Map<Integer, String> getSuffixes() {
        return this.group().getCachedData().getMetaData(this.options()).getSuffixes();
    }

    @Override
    public OptionalInt getWeight() {
        return this.group().getWeight();
    }

    @Override
    public String getName() {
        return this.group().getName();
    }

    @Override
    public Optional<World> getWorld() {
        return Optional.ofNullable(this.world());
    }

    @Override
    public boolean setDisplayName(@Nullable String displayName) {
        if (displayName == null) {
            this.group.data().clear(node -> node instanceof DisplayNameNode);
            return true;
        }
        DataMutateResult result = this.group().data().add((Node)((DisplayNameNode.Builder)DisplayNameNode.builder((String)displayName).context((ContextSet)this.options().context())).build());
        LuckPermsProvider.get().getGroupManager().saveGroup(this.group());
        return result.wasSuccessful();
    }

    @Override
    public boolean setWeight(int weight) {
        DataMutateResult result = this.group().data().add((Node)((WeightNode.Builder)WeightNode.builder((int)weight).context((ContextSet)this.options().context())).build());
        LuckPermsProvider.get().getGroupManager().saveGroup(this.group());
        return result.wasSuccessful();
    }

    @Override
    public boolean setPrefix(@Nullable String prefix, int priority) {
        if (prefix == null) {
            this.group.data().clear(node -> node instanceof PrefixNode);
            return true;
        }
        DataMutateResult result = this.group().data().add((Node)((PrefixNode.Builder)PrefixNode.builder((String)prefix, (int)priority).context((ContextSet)this.options().context())).build());
        LuckPermsProvider.get().getGroupManager().saveGroup(this.group());
        return result.wasSuccessful();
    }

    @Override
    public boolean setSuffix(@Nullable String suffix, int priority) {
        if (suffix == null) {
            this.group.data().clear(node -> node instanceof SuffixNode);
            return true;
        }
        DataMutateResult result = this.group().data().add((Node)((SuffixNode.Builder)SuffixNode.builder((String)suffix, (int)priority).context((ContextSet)this.options().context())).build());
        LuckPermsProvider.get().getGroupManager().saveGroup(this.group());
        return result.wasSuccessful();
    }

    @Override
    public @Unmodifiable Map<String, Boolean> getPermissions() {
        return this.group().getCachedData().getPermissionData().getPermissionMap();
    }

    @Override
    public TriState checkPermission(String permission) {
        return switch (this.group().getCachedData().getPermissionData(this.options()).checkPermission(permission)) {
            default -> throw new MatchException(null, null);
            case Tristate.FALSE -> TriState.FALSE;
            case Tristate.TRUE -> TriState.TRUE;
            case Tristate.UNDEFINED -> TriState.NOT_SET;
        };
    }

    @Override
    public boolean addPermission(String permission) {
        return this.setPermission(permission, true);
    }

    @Override
    public boolean removePermission(String permission) {
        DataMutateResult result = this.group().data().remove((Node)Node.builder((String)permission).context((ContextSet)this.options().context()).build());
        LuckPermsProvider.get().getGroupManager().saveGroup(this.group());
        return result.wasSuccessful();
    }

    @Override
    public boolean setPermission(String permission, boolean value) {
        DataMutateResult result = this.group().data().add((Node)Node.builder((String)permission).value(value).context((ContextSet)this.options().context()).build());
        LuckPermsProvider.get().getGroupManager().saveGroup(this.group());
        return result.wasSuccessful();
    }

    @Override
    public <T> Optional<T> getInfoNode(String key, Function<String, T> mapper) {
        return this.group().getCachedData().getMetaData(this.options()).getMetaValue(key, mapper);
    }

    @Override
    public boolean setInfoNode(String key, String value) {
        DataMutateResult result = this.group().data().add((Node)((MetaNode.Builder)MetaNode.builder((String)key, (String)value).context((ContextSet)this.options().context())).build());
        LuckPermsProvider.get().getGroupManager().saveGroup(this.group());
        return result.wasSuccessful();
    }

    @Override
    public boolean removeInfoNode(String key) {
        this.group().data().clear((ContextSet)this.options().context(), node -> node.getKey().equals(key));
        LuckPermsProvider.get().getGroupManager().saveGroup(this.group());
        return true;
    }

    @Override
    public boolean removeInfoNode(String key, String value) {
        DataMutateResult result = this.group().data().remove((Node)((MetaNode.Builder)MetaNode.builder((String)key, (String)value).context((ContextSet)this.options().context())).build());
        LuckPermsProvider.get().getGroupManager().saveGroup(this.group());
        return result.wasSuccessful();
    }
}

