/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.command;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.service.ServicePlugin;
import net.thenextlvl.service.api.Controller;
import net.thenextlvl.service.api.character.Character;
import net.thenextlvl.service.api.character.CharacterController;
import net.thenextlvl.service.api.chat.ChatController;
import net.thenextlvl.service.api.economy.Account;
import net.thenextlvl.service.api.economy.EconomyController;
import net.thenextlvl.service.api.economy.bank.BankController;
import net.thenextlvl.service.api.group.GroupController;
import net.thenextlvl.service.api.hologram.Hologram;
import net.thenextlvl.service.api.hologram.HologramController;
import net.thenextlvl.service.api.permission.PermissionController;
import net.thenextlvl.service.command.argument.ControllerArgumentType;
import net.thenextlvl.service.command.brigadier.BrigadierCommand;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class ServiceConvertCommand
extends BrigadierCommand {
    private final AtomicBoolean conversionRunning = new AtomicBoolean(false);

    private ServiceConvertCommand(ServicePlugin plugin) {
        super(plugin, "convert", "service.convert");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(ServicePlugin plugin) {
        ServiceConvertCommand command = new ServiceConvertCommand(plugin);
        LiteralArgumentBuilder<CommandSourceStack> banks = command.converter("banks", BankController.class, new BankConverter());
        LiteralArgumentBuilder<CommandSourceStack> characters = command.converter("characters", CharacterController.class, new CharacterConverter());
        LiteralArgumentBuilder<CommandSourceStack> chat = command.converter("chat", ChatController.class, new ChatConverter());
        LiteralArgumentBuilder<CommandSourceStack> economy = command.converter("economy", EconomyController.class, new EconomyConverter());
        LiteralArgumentBuilder<CommandSourceStack> groups = command.converter("groups", GroupController.class, new GroupConverter());
        LiteralArgumentBuilder<CommandSourceStack> holograms = command.converter("holograms", HologramController.class, new HologramConverter());
        LiteralArgumentBuilder<CommandSourceStack> permissions = command.converter("permissions", PermissionController.class, new PermissionConverter());
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)command.create().then(banks)).then(characters)).then(chat)).then(economy)).then(groups)).then(holograms)).then(permissions);
    }

    private <C extends Controller> LiteralArgumentBuilder<CommandSourceStack> converter(String name, Class<C> type, Converter<C> converter) {
        return (LiteralArgumentBuilder)Commands.literal((String)name).then(this.converter(type, converter));
    }

    private <C extends Controller> ArgumentBuilder<CommandSourceStack, ?> converter(Class<C> type, Converter<C> converter) {
        return Commands.argument((String)"source", new ControllerArgumentType<Controller>(this.plugin, type, (c, e) -> true)).then(Commands.argument((String)"target", new ControllerArgumentType<Controller>(this.plugin, type, (context, controller) -> !((Controller)context.getLastChild().getArgument("source", type)).equals(controller))).executes(context -> this.convert((CommandContext<CommandSourceStack>)context, type, converter)));
    }

    private <C extends Controller> int convert(CommandContext<CommandSourceStack> context, Class<C> type, Converter<C> converter) {
        Controller target;
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        if (this.conversionRunning.get()) {
            this.plugin.bundle().sendMessage((Audience)sender, "service.convert.running");
            return 0;
        }
        Controller source = (Controller)context.getArgument("source", type);
        if (source.equals(target = (Controller)context.getArgument("target", type))) {
            this.plugin.bundle().sendMessage((Audience)sender, "service.convert.source-target");
            return 0;
        }
        this.plugin.getServer().getAsyncScheduler().runNow((Plugin)this.plugin, scheduledTask -> {
            this.plugin.bundle().sendMessage((Audience)sender, "service.convert.start", new TagResolver[]{Placeholder.parsed((String)"source", (String)source.getName()), Placeholder.parsed((String)"target", (String)target.getName())});
            long now = System.currentTimeMillis();
            this.conversionRunning.set(true);
            ((CompletableFuture)converter.convert(source, target).thenAccept(unused -> {
                this.conversionRunning.set(false);
                String time = new DecimalFormat("0.000").format((double)(System.currentTimeMillis() - now) / 1000.0);
                this.plugin.bundle().sendMessage((Audience)sender, "service.convert.done", new TagResolver[]{Placeholder.parsed((String)"time", (String)time)});
            })).exceptionally(throwable -> {
                this.conversionRunning.set(false);
                String time = new DecimalFormat("0.000").format((double)(System.currentTimeMillis() - now) / 1000.0);
                this.plugin.bundle().sendMessage((Audience)sender, "service.convert.failed", new TagResolver[]{Placeholder.parsed((String)"time", (String)time)});
                this.plugin.getComponentLogger().error("Data conversion failed after {} seconds", (Object)time, throwable);
                return null;
            });
        });
        return 1;
    }

    private static final class BankConverter
    extends PlayerConverter<BankController> {
        private BankConverter() {
        }

        @Override
        public CompletableFuture<Void> convert(OfflinePlayer player, BankController source, BankController target) {
            return source.loadBanks().thenAccept(banks -> banks.forEach(bank -> bank.getWorld().map(world -> target.createBank(bank.getOwner(), bank.getName(), (World)world)).orElseGet(() -> target.createBank(bank.getOwner(), bank.getName())).thenAccept(targetBank -> {
                targetBank.setBalance(bank.getBalance());
                bank.getMembers().forEach(targetBank::addMember);
            })));
        }
    }

    @FunctionalInterface
    private static interface Converter<C extends Controller> {
        public CompletableFuture<Void> convert(C var1, C var2);
    }

    private static final class CharacterConverter
    implements Converter<CharacterController> {
        private CharacterConverter() {
        }

        @Override
        public CompletableFuture<Void> convert(CharacterController source, CharacterController target) {
            return CompletableFuture.runAsync(() -> source.getNPCs().forEach(character -> this.convert((Character<?>)character, source, target)));
        }

        public CompletableFuture<Void> convert(Character<?> character, CharacterController source, CharacterController target) {
            return CompletableFuture.runAsync(() -> target.getNPC(character.getName()).orElseGet(() -> {
                Character npc = target.createNPC(character.getName(), character.getType());
                npc.setDisplayName(character.getDisplayName());
                npc.setDisplayRange(character.getDisplayRange());
                npc.setInvulnerable(character.isInvulnerable());
                npc.setPersistent(character.isPersistent());
                npc.setTablistEntryHidden(character.isTablistEntryHidden());
                npc.setVisibleByDefault(character.isVisibleByDefault());
                if (character.getLocation() != null) {
                    npc.spawn(character.getLocation());
                }
                character.addViewers(npc.getViewers());
                return npc;
            }));
        }
    }

    private static final class ChatConverter
    extends PlayerConverter<ChatController> {
        private ChatConverter() {
        }

        @Override
        public CompletableFuture<Void> convert(OfflinePlayer player, ChatController source, ChatController target) {
            return source.tryGetProfile(player).thenAccept(profile -> target.tryGetProfile(player).thenAccept(targetProfile -> {
                profile.getPrefixes().forEach((priority, prefix) -> targetProfile.setPrefix((String)prefix, (int)priority));
                profile.getSuffixes().forEach((priority, suffix) -> targetProfile.setSuffix((String)suffix, (int)priority));
                profile.getDisplayName().ifPresent(targetProfile::setDisplayName);
            }));
        }
    }

    private static final class EconomyConverter
    implements Converter<EconomyController> {
        private EconomyConverter() {
        }

        @Override
        public CompletableFuture<Void> convert(EconomyController source, EconomyController target) {
            return source.loadAccounts().thenCompose(accounts -> CompletableFuture.allOf((CompletableFuture[])accounts.stream().map(account -> this.convert((Account)account, source, target)).toArray(CompletableFuture[]::new)));
        }

        public CompletableFuture<Void> convert(Account account, EconomyController source, EconomyController target) {
            return account.getWorld().map(world -> ((CompletableFuture)target.tryGetAccount(account.getOwner(), (World)world).thenCompose(account1 -> account1.map(CompletableFuture::completedFuture).orElseGet(() -> target.createAccount(account.getOwner(), (World)world)))).thenAccept(account1 -> account1.setBalance(account.getBalance()))).orElseGet(() -> ((CompletableFuture)target.tryGetAccount(account.getOwner()).thenCompose(account1 -> account1.map(CompletableFuture::completedFuture).orElseGet(() -> target.createAccount(account.getOwner())))).thenAccept(account1 -> account1.setBalance(account.getBalance())));
        }
    }

    private static final class GroupConverter
    extends PlayerConverter<GroupController> {
        private GroupConverter() {
        }

        @Override
        public CompletableFuture<Void> convert(OfflinePlayer player, GroupController source, GroupController target) {
            return source.tryGetGroupHolder(player).thenAccept(holder -> target.tryGetGroupHolder(player).thenAccept(targetHolder -> {
                holder.getGroups().forEach(targetHolder::addGroup);
                holder.getPermissions().forEach(targetHolder::setPermission);
                targetHolder.setPrimaryGroup(holder.getPrimaryGroup());
            }));
        }

        @Override
        public CompletableFuture<Void> convert(GroupController source, GroupController target) {
            source.loadGroups().thenAccept(groups -> groups.forEach(group -> group.getWorld().map(world -> target.createGroup(group.getName(), (World)world)).orElseGet(() -> target.createGroup(group.getName())).thenAccept(targetGroup -> {
                group.getDisplayName().ifPresent(targetGroup::setDisplayName);
                group.getPermissions().forEach(targetGroup::setPermission);
                group.getPrefixes().forEach((priority, prefix) -> targetGroup.setPrefix((String)prefix, (int)priority));
                group.getSuffixes().forEach((priority, suffix) -> targetGroup.setSuffix((String)suffix, (int)priority));
                group.getWeight().ifPresent(targetGroup::setWeight);
            })));
            return super.convert(source, target);
        }
    }

    private static final class HologramConverter
    implements Converter<HologramController> {
        private HologramConverter() {
        }

        @Override
        public CompletableFuture<Void> convert(HologramController source, HologramController target) {
            return CompletableFuture.runAsync(() -> source.getHolograms().forEach(hologram -> {
                Hologram created = target.createHologram(hologram.getName(), hologram.getLocation(), hologram.getLines());
                created.addViewers(hologram.getViewers());
                created.setDisplayRange(hologram.getDisplayRange());
                created.setPersistent(hologram.isPersistent());
                created.setVisibleByDefault(hologram.isVisibleByDefault());
                created.persist();
            }));
        }
    }

    private static final class PermissionConverter
    extends PlayerConverter<PermissionController> {
        private PermissionConverter() {
        }

        @Override
        public CompletableFuture<Void> convert(OfflinePlayer player, PermissionController source, PermissionController target) {
            return source.tryGetPermissionHolder(player).thenAccept(holder -> target.tryGetPermissionHolder(player).thenAccept(targetHolder -> holder.getPermissions().forEach(targetHolder::setPermission)));
        }
    }

    private static abstract class PlayerConverter<C extends Controller>
    implements Converter<C> {
        private PlayerConverter() {
        }

        public abstract CompletableFuture<Void> convert(OfflinePlayer var1, C var2, C var3);

        @Override
        public CompletableFuture<Void> convert(C source, C target) {
            return CompletableFuture.allOf((CompletableFuture[])Arrays.stream(source.getPlugin().getServer().getOfflinePlayers()).map(player -> this.convert((OfflinePlayer)player, source, target)).toArray(CompletableFuture[]::new));
        }
    }
}

