/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service;

import io.papermc.paper.plugin.bootstrap.BootstrapContext;
import io.papermc.paper.plugin.bootstrap.PluginBootstrap;
import io.papermc.paper.plugin.bootstrap.PluginProviderContext;
import io.papermc.paper.plugin.configuration.PluginMeta;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.plugin.java.JavaPlugin;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class ServiceBootstrapper
implements PluginBootstrap {
    public static final String ISSUES = "https://github.com/TheNextLvl-net/service-io/issues/new?template=bug_report.yml";
    public static final boolean COMPATIBILITY_MODE = Boolean.parseBoolean(System.getenv("COMPATIBILITY_MODE"));

    public void bootstrap(BootstrapContext context) {
    }

    public JavaPlugin createPlugin(PluginProviderContext context) {
        JavaPlugin plugin = super.createPlugin(context);
        if (COMPATIBILITY_MODE) {
            this.enableCompatibilityMode(context);
        }
        return plugin;
    }

    private void enableCompatibilityMode(PluginProviderContext context) {
        ComponentLogger logger = context.getLogger();
        try {
            PluginMeta meta = context.getConfiguration();
            Class metaClass = meta.getClass();
            Field name = metaClass.getDeclaredField("name");
            Field provides = metaClass.getDeclaredField("provides");
            name.trySetAccessible();
            provides.trySetAccessible();
            ArrayList<String> providedPlugins = new ArrayList<String>(meta.getProvidedPlugins());
            providedPlugins.remove("Vault");
            providedPlugins.add(meta.getName());
            name.set(meta, "Vault");
            provides.set(meta, List.copyOf(providedPlugins));
            logger.info("Enabled compatibility mode, only use this if you really need to.");
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            logger.warn("Failed to initialize compatibility mode", (Throwable)e);
            logger.warn("Please look for similar issues or report this on GitHub: {}", (Object)ISSUES);
        }
    }
}

