/*
 * Decompiled with CFR 0.152.
 */
package core.paper.command.argument;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import core.paper.command.ComponentCommandExceptionType;
import core.paper.command.argument.codec.EnumStringCodec;
import io.papermc.paper.command.brigadier.argument.CustomArgumentType;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class EnumArgumentType<E extends Enum<E>>
implements CustomArgumentType<E, String> {
    private final Class<E> enumClass;
    private final EnumStringCodec codec;

    private EnumArgumentType(Class<E> enumClass, EnumStringCodec codec) {
        this.enumClass = enumClass;
        this.codec = codec;
    }

    @Contract(value="_, _ -> new", pure=true)
    public static <E extends Enum<E>> EnumArgumentType<E> of(Class<E> enumClass, EnumStringCodec codec) {
        return new EnumArgumentType<E>(enumClass, codec);
    }

    public E parse(StringReader reader) throws CommandSyntaxException {
        String type = (String)this.getNativeType().parse(reader);
        try {
            return this.codec.fromString(this.enumClass, type);
        }
        catch (IllegalArgumentException ignore) {
            throw new ComponentCommandExceptionType((Component)Component.text((String)("No such enum constant: " + type))).createWithContext((ImmutableStringReader)reader);
        }
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        Arrays.stream((Enum[])this.enumClass.getEnumConstants()).map(this.codec::toString).map(StringArgumentType::escapeIfRequired).filter(s -> s.contains(builder.getRemaining())).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    public ArgumentType<String> getNativeType() {
        return StringArgumentType.string();
    }
}

