/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.protect.listeners;

import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.kyori.adventure.audience.Audience;
import net.thenextlvl.protect.ProtectPlugin;
import net.thenextlvl.protect.area.Area;
import net.thenextlvl.protect.flag.Flag;
import net.thenextlvl.protect.flag.ProtectionFlag;
import net.thenextlvl.protect.utils.BlockUtil;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Farmland;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFertilizeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.block.BlockPistonEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockReceiveGameEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.CauldronLevelChangeEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.block.MoistureChangeEvent;
import org.bukkit.event.block.SpongeAbsorbEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldSaveEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.jspecify.annotations.Nullable;

public final class WorldListener
implements Listener {
    private final ProtectPlugin plugin;

    public WorldListener(ProtectPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onWorldLoad(WorldLoadEvent event) {
        this.plugin.areaProvider().load(event.getWorld());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onWorldUnload(WorldUnloadEvent event) {
        this.plugin.areaProvider().save(event.getWorld());
        this.plugin.areaProvider().unload(event.getWorld());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWorldSave(WorldSaveEvent event) {
        this.plugin.areaProvider().save(event.getWorld());
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        event.setCancelled(!this.plugin.protectionService().canDestroy((Entity)event.getPlayer(), event.getBlock().getLocation()));
        this.plugin.failed((Audience)event.getPlayer(), (Cancellable)event, this.plugin.areaProvider().getArea(event.getBlock()), "area.failed.break");
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        event.setCancelled(!this.plugin.protectionService().canPlace((Entity)event.getPlayer(), event.getBlock().getLocation()));
        this.plugin.failed((Audience)event.getPlayer(), (Cancellable)event, this.plugin.areaProvider().getArea(event.getBlock()), "area.failed.place");
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPhysicalInteract(PlayerInteractEvent event) {
        if (!event.getAction().equals((Object)Action.PHYSICAL)) {
            return;
        }
        if (event.getClickedBlock() == null) {
            return;
        }
        Location location = event.getClickedBlock().getLocation();
        event.setCancelled(event.getClickedBlock().getType().equals((Object)Material.FARMLAND) ? !this.plugin.protectionService().canTrample((Entity)event.getPlayer(), location) : !this.plugin.protectionService().canInteractPhysical((Entity)event.getPlayer(), location));
        if (!event.getClickedBlock().getType().equals((Object)Material.FARMLAND)) {
            return;
        }
        this.plugin.failed((Audience)event.getPlayer(), (Cancellable)event, this.plugin.areaProvider().getArea(location), "area.failed.break");
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            return;
        }
        if (event.getClickedBlock() == null) {
            return;
        }
        if (event.getPlayer().isSneaking() && event.hasItem() && event.getMaterial().isBlock()) {
            return;
        }
        if (!BlockUtil.isInteractable(event.getClickedBlock().getType(), event.getMaterial())) {
            return;
        }
        event.setCancelled(!this.plugin.protectionService().canInteract((Entity)event.getPlayer(), event.getClickedBlock().getLocation()));
        this.plugin.failed((Audience)event.getPlayer(), (Cancellable)event, this.plugin.areaProvider().getArea(event.getClickedBlock()), "area.failed.interact");
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockMultiPlace(BlockMultiPlaceEvent event) {
        event.setCancelled(!event.getReplacedBlockStates().stream().allMatch(blockState -> this.plugin.protectionService().canPlace((Entity)event.getPlayer(), blockState.getLocation())));
        this.plugin.failed((Audience)event.getPlayer(), (Cancellable)event, this.plugin.areaProvider().getArea(event.getBlock()), "area.failed.place");
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockReceiveGameEvent(BlockReceiveGameEvent event) {
        event.setCancelled(this.isInteractionRestricted(event.getBlock().getLocation(), event.getEntity() != null ? event.getEntity().getLocation() : null, this.plugin.flags.gameEvents));
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockFade(BlockFadeEvent event) {
        Area area = this.plugin.areaProvider().getArea(event.getBlock());
        event.setCancelled(area.getFlag(this.plugin.flags.blockFading) == false);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockForm(BlockFormEvent event) {
        event.setCancelled(this.isInteractionRestricted(event.getBlock().getLocation(), event.getNewState().getLocation(), this.plugin.flags.blockForming));
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockBurn(BlockBurnEvent event) {
        event.setCancelled(this.isInteractionRestricted(Objects.requireNonNullElse(event.getIgnitingBlock(), event.getBlock()).getLocation(), event.getBlock().getLocation(), this.plugin.flags.blockBurning));
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockIgnite(BlockIgniteEvent event) {
        event.setCancelled(this.isInteractionRestricted(event.getIgnitingBlock() != null ? event.getIgnitingBlock().getLocation() : (event.getIgnitingEntity() != null ? event.getIgnitingEntity().getLocation() : event.getBlock().getLocation()), event.getBlock().getLocation(), this.plugin.flags.blockIgniting));
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onMoistureChange(MoistureChangeEvent event) {
        BlockData blockData = event.getBlock().getBlockData();
        if (!(blockData instanceof Farmland)) {
            return;
        }
        Farmland current = (Farmland)blockData;
        BlockData blockData2 = event.getNewState().getBlockData();
        if (!(blockData2 instanceof Farmland)) {
            return;
        }
        Farmland future = (Farmland)blockData2;
        Area area = this.plugin.areaProvider().getArea(event.getBlock());
        event.setCancelled(area.getFlag(current.getMoisture() > future.getMoisture() ? this.plugin.flags.blockDrying : this.plugin.flags.blockMoisturising) == false);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onLiquidFlow(BlockFromToEvent event) {
        if (!event.getBlock().isLiquid()) {
            return;
        }
        event.setCancelled(this.isInteractionRestricted(event.getBlock().getLocation(), event.getToBlock().getLocation(), this.plugin.flags.liquidFlow));
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockGrow(BlockGrowEvent event) {
        Area area = this.plugin.areaProvider().getArea(event.getBlock());
        event.setCancelled(area.getFlag(this.plugin.flags.blockGrowth) == false);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onSpongeAbsorb(SpongeAbsorbEvent event) {
        this.filterStates(event.getBlock().getLocation(), event.getBlocks(), null, this.plugin.flags.blockAbsorb);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onStructureGrow(StructureGrowEvent event) {
        this.filterStates(event.getLocation(), event.getBlocks(), event.getPlayer(), this.plugin.flags.blockGrowth);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockFertilize(BlockFertilizeEvent event) {
        this.filterStates(event.getBlock().getLocation(), event.getBlocks(), event.getPlayer(), this.plugin.flags.blockFertilize);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockExplode(BlockExplodeEvent event) {
        this.filterBlocks(event.getBlock().getLocation(), event.blockList(), this.plugin.flags.explosions);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityExplode(EntityExplodeEvent event) {
        this.filterBlocks(event.getLocation(), event.blockList(), this.plugin.flags.explosions);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockRedstone(BlockRedstoneEvent event) {
        Area area = this.plugin.areaProvider().getArea(event.getBlock());
        if (!area.getFlag(this.plugin.flags.redstone).booleanValue()) {
            event.setNewCurrent(event.getOldCurrent());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerBucketFill(PlayerBucketFillEvent event) {
        event.setCancelled(!this.plugin.protectionService().canDestroy((Entity)event.getPlayer(), event.getBlock().getLocation()));
        this.plugin.failed((Audience)event.getPlayer(), (Cancellable)event, this.plugin.areaProvider().getArea(event.getBlock()), "area.failed.break");
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerBucketEmpty(PlayerBucketEmptyEvent event) {
        event.setCancelled(!this.plugin.protectionService().canDestroy((Entity)event.getPlayer(), event.getBlock().getLocation()));
        this.plugin.failed((Audience)event.getPlayer(), (Cancellable)event, this.plugin.areaProvider().getArea(event.getBlock()), "area.failed.place");
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockSpread(BlockSpreadEvent event) {
        event.setCancelled(this.isInteractionRestricted(event.getSource().getLocation(), event.getBlock().getLocation(), this.plugin.flags.blockSpread));
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onLeavesDecay(LeavesDecayEvent event) {
        Area area = this.plugin.areaProvider().getArea(event.getBlock());
        event.setCancelled(area.getFlag(this.plugin.flags.leavesDecay) == false);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onCauldronLevelChange(CauldronLevelChangeEvent event) {
        ProtectionFlag<Boolean> flag;
        Area area = this.plugin.areaProvider().getArea(event.getBlock());
        switch (event.getReason()) {
            case EXTINGUISH: {
                ProtectionFlag<Boolean> protectionFlag = this.plugin.flags.cauldronExtinguishEntity;
                break;
            }
            case EVAPORATE: {
                ProtectionFlag<Boolean> protectionFlag = this.plugin.flags.cauldronEvaporation;
                break;
            }
            case NATURAL_FILL: {
                ProtectionFlag<Boolean> protectionFlag = this.plugin.flags.naturalCauldronFill;
                break;
            }
            default: {
                ProtectionFlag<Boolean> protectionFlag = flag = null;
            }
        }
        if (flag != null) {
            event.setCancelled(area.getFlag(flag) == false);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockPistonExtend(BlockPistonExtendEvent event) {
        this.handlePistonMovement((BlockPistonEvent)event, event.getDirection(), event.getBlocks(), 1);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockPistonRetract(BlockPistonRetractEvent event) {
        this.handlePistonMovement((BlockPistonEvent)event, event.getDirection(), event.getBlocks(), 0);
    }

    private void handlePistonMovement(BlockPistonEvent event, BlockFace direction, List<Block> blocks, int offset) {
        Area relative;
        Area area = this.plugin.areaProvider().getArea(event.getBlock());
        event.setCancelled(!area.canInteract(relative = this.plugin.areaProvider().getArea(event.getBlock().getRelative(direction))) || !blocks.stream().allMatch(block -> area.canInteract(this.plugin.areaProvider().getArea(block.getRelative(direction, offset)))));
    }

    private boolean isInteractionRestricted(Location source, @Nullable Location target, Flag<Boolean> flag) {
        Area area = this.plugin.areaProvider().getArea(source);
        if (!area.getFlag(flag).booleanValue()) {
            return true;
        }
        return target != null && !source.equals((Object)target) && !area.canInteract(this.plugin.areaProvider().getArea(target));
    }

    private void filterStates(Location source, List<BlockState> blocks, @Nullable Player player, Flag<Boolean> flag) {
        this.filter(source, blocks, BlockState::getLocation, player, flag);
    }

    private void filterBlocks(Location source, List<Block> blocks, Flag<Boolean> flag) {
        this.filter(source, blocks, Block::getLocation, null, flag);
    }

    private <T> void filter(Location source, List<T> list, Function<T, Location> function, @Nullable Player player, Flag<Boolean> flag) {
        this.filter(source, list, function, (area, target) -> {
            if (player == null) {
                return area.canInteract((Area)target) && (Boolean)target.getFlag(flag) != false;
            }
            return target.isPermitted(player.getUniqueId()) || (Boolean)target.getFlag(flag) != false;
        });
    }

    private <T> void filter(Location source, List<T> list, Function<T, Location> function, BiPredicate<Area, Area> filter) {
        Area area = this.plugin.areaProvider().getArea(source);
        list.removeIf(object -> !filter.test(area, this.plugin.areaProvider().getArea((Location)function.apply(object))));
    }
}

