/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.protect.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.sk89q.worldedit.WorldEditException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.protect.ProtectPlugin;
import net.thenextlvl.protect.area.RegionizedArea;
import net.thenextlvl.protect.commands.argument.RegionizedAreaArgumentType;
import org.bukkit.command.CommandSender;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class AreaSchematicCommand {
    AreaSchematicCommand() {
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(ProtectPlugin plugin) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"schematic").requires(stack -> stack.getSender().hasPermission("protect.command.area.schematic"))).then(AreaSchematicCommand.delete(plugin))).then(AreaSchematicCommand.load(plugin))).then(AreaSchematicCommand.save(plugin));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> delete(ProtectPlugin plugin) {
        return ((LiteralArgumentBuilder)Commands.literal((String)"delete").requires(stack -> stack.getSender().hasPermission("protect.command.area.schematic.delete"))).then(Commands.argument((String)"area", (ArgumentType)new RegionizedAreaArgumentType(plugin, area -> Files.isRegularFile(area.getSchematicFile(), new LinkOption[0]))).executes(context -> AreaSchematicCommand.delete((CommandContext<CommandSourceStack>)context, plugin)));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> load(ProtectPlugin plugin) {
        return ((LiteralArgumentBuilder)Commands.literal((String)"load").requires(stack -> stack.getSender().hasPermission("protect.command.area.schematic.load"))).then(Commands.argument((String)"area", (ArgumentType)new RegionizedAreaArgumentType(plugin, area -> Files.isRegularFile(area.getSchematicFile(), new LinkOption[0]))).executes(context -> AreaSchematicCommand.load((CommandContext<CommandSourceStack>)context, plugin)));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> save(ProtectPlugin plugin) {
        return ((LiteralArgumentBuilder)Commands.literal((String)"save").requires(stack -> stack.getSender().hasPermission("protect.command.area.schematic.save"))).then(Commands.argument((String)"area", (ArgumentType)new RegionizedAreaArgumentType(plugin)).executes(context -> AreaSchematicCommand.save((CommandContext<CommandSourceStack>)context, plugin)));
    }

    private static int delete(CommandContext<CommandSourceStack> context, ProtectPlugin plugin) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        RegionizedArea area = (RegionizedArea)context.getArgument("area", RegionizedArea.class);
        String message = area.deleteSchematic() ? "area.schematic.delete.success" : "area.schematic.delete.failed";
        plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{Placeholder.parsed((String)"schematic", (String)area.getSchematicFile().getFileName().toString())});
        return 1;
    }

    private static int load(CommandContext<CommandSourceStack> context, ProtectPlugin plugin) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        RegionizedArea area = (RegionizedArea)context.getArgument("area", RegionizedArea.class);
        if (area.isTooBig()) {
            plugin.bundle().sendMessage((Audience)sender, "area.warning.size");
        }
        boolean load = false;
        try {
            load = area.loadSchematic();
        }
        catch (WorldEditException | IOException e) {
            plugin.getComponentLogger().error("Failed to load area schematic", e);
            plugin.getComponentLogger().error("Please look for similar issues or report this on GitHub: {}", (Object)"https://github.com/TheNextLvl-net/protect/issues/new?template=bug_report.yml");
            ProtectPlugin.ERROR_TRACKER.trackError(e);
        }
        String message = load ? "area.schematic.load.success" : "area.schematic.load.failed";
        plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{Placeholder.parsed((String)"schematic", (String)area.getSchematicFile().getFileName().toString())});
        return 1;
    }

    private static int save(CommandContext<CommandSourceStack> context, ProtectPlugin plugin) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        RegionizedArea area = (RegionizedArea)context.getArgument("area", RegionizedArea.class);
        if (area.isTooBig()) {
            plugin.bundle().sendMessage((Audience)sender, "area.warning.size");
        }
        try {
            area.saveSchematic();
            long size = 0L;
            try {
                size = Files.size(area.getSchematicFile()) / 1024L;
            }
            catch (IOException e) {
                plugin.getComponentLogger().warn("Failed to get file size of area {}", (Object)area.getName(), (Object)e);
            }
            plugin.bundle().sendMessage((Audience)sender, "area.schematic.save.success", new TagResolver[]{Placeholder.parsed((String)"schematic", (String)area.getSchematicFile().getFileName().toString()), Formatter.number((String)"size", (Number)size)});
        }
        catch (WorldEditException | IOException e) {
            plugin.bundle().sendMessage((Audience)sender, "area.schematic.save.failed", new TagResolver[]{Placeholder.parsed((String)"schematic", (String)area.getSchematicFile().getFileName().toString())});
            plugin.getComponentLogger().error("Failed to save area schematic", e);
            plugin.getComponentLogger().error("Please look for similar issues or report this on GitHub: {}", (Object)"https://github.com/TheNextLvl-net/protect/issues/new?template=bug_report.yml");
            ProtectPlugin.ERROR_TRACKER.trackError(e);
        }
        return 1;
    }
}

