/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.protect.area;

import com.sk89q.worldedit.regions.Region;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.thenextlvl.protect.area.Area;
import net.thenextlvl.protect.area.RegionizedArea;
import net.thenextlvl.protect.exception.CircularInheritanceException;
import net.thenextlvl.protect.exception.UnsupportedRegionException;
import net.thenextlvl.protect.flag.Flag;
import org.bukkit.World;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public interface AreaCreator<T extends Region> {
    @Contract(pure=true)
    public String name();

    @Contract(pure=true)
    public @Nullable UUID owner();

    @Contract(value=" -> new", pure=true)
    public AreaCreator<T> copy();

    @Contract(mutates="this")
    public AreaCreator<T> flags(Map<Flag<?>, @Nullable Object> var1);

    @Contract(mutates="this")
    public AreaCreator<T> members(Set<UUID> var1);

    @Contract(mutates="this")
    public AreaCreator<T> name(String var1);

    @Contract(mutates="this")
    public AreaCreator<T> owner(@Nullable UUID var1);

    @Contract(mutates="this")
    public AreaCreator<T> parent(@Nullable String var1);

    @Contract(mutates="this")
    public AreaCreator<T> parent(@Nullable Area var1);

    @Contract(mutates="this")
    public AreaCreator<T> priority(int var1);

    @Contract(value="_ -> new", pure=true)
    public <V extends Region> AreaCreator<V> region(V var1);

    @Contract(mutates="this")
    public AreaCreator<T> world(World var1);

    @Contract(pure=true)
    public @Unmodifiable Map<Flag<?>, @Nullable Object> flags();

    @Contract(value="-> new", mutates="io")
    public RegionizedArea<T> create() throws UnsupportedRegionException, CircularInheritanceException, IOException;

    @Contract(pure=true)
    public @Unmodifiable Set<UUID> members();

    @Contract(pure=true)
    public @Nullable String parent();

    @Contract(pure=true)
    public T region();

    @Contract(pure=true)
    public World world();

    @Contract(pure=true)
    public int priority();
}

