/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.protect.controllers;

import java.util.Optional;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Team;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class CollisionController {
    private static final String TEAM_NAME = "collision_protection";
    private @Nullable Team collisionTeam;

    private Team getOrCreateCollisionTeam(Player player) {
        return this.getCollisionTeam(player).orElseGet(() -> {
            Team team = player.getScoreboard().registerNewTeam(TEAM_NAME);
            team.setOption(Team.Option.COLLISION_RULE, Team.OptionStatus.NEVER);
            return team;
        });
    }

    private Optional<Team> getCollisionTeam(Player player) {
        return Optional.ofNullable(player.getScoreboard().getTeam(TEAM_NAME));
    }

    public void setCollidable(Player player, boolean collides) {
        Team team = this.getOrCreateCollisionTeam(player);
        if (collides) {
            team.removePlayer((OfflinePlayer)player);
        } else {
            team.addPlayer((OfflinePlayer)player);
        }
    }

    public void remove(Player player) {
        this.getCollisionTeam(player).ifPresent(Team::unregister);
    }
}

