/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.protect;

import com.fastasyncworldedit.core.regions.FaweMaskManager;
import com.fastasyncworldedit.core.util.WEManager;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.reflect.TypeToken;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector2;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.CylinderRegion;
import com.sk89q.worldedit.regions.EllipsoidRegion;
import dev.faststats.bukkit.BukkitMetrics;
import dev.faststats.core.ErrorTracker;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.i18n.ComponentBundle;
import net.thenextlvl.nbt.serialization.NBT;
import net.thenextlvl.protect.adapters.FlagsAdapter;
import net.thenextlvl.protect.adapters.KeyAdapter;
import net.thenextlvl.protect.adapters.LocationAdapter;
import net.thenextlvl.protect.adapters.MembersAdapter;
import net.thenextlvl.protect.adapters.WeatherTypeAdapter;
import net.thenextlvl.protect.adapters.WorldAdapter;
import net.thenextlvl.protect.adapters.area.CuboidAreaAdapter;
import net.thenextlvl.protect.adapters.area.CylinderAreaAdapter;
import net.thenextlvl.protect.adapters.area.EllipsoidAreaAdapter;
import net.thenextlvl.protect.adapters.area.GlobalAreaAdapter;
import net.thenextlvl.protect.adapters.area.GroupedAreaAdapter;
import net.thenextlvl.protect.adapters.region.CuboidRegionAdapter;
import net.thenextlvl.protect.adapters.region.CylinderRegionAdapter;
import net.thenextlvl.protect.adapters.region.EllipsoidRegionAdapter;
import net.thenextlvl.protect.adapters.region.GroupedRegionAdapter;
import net.thenextlvl.protect.adapters.vector.BlockVectorAdapter;
import net.thenextlvl.protect.adapters.vector.Vector2Adapter;
import net.thenextlvl.protect.adapters.vector.Vector3Adapter;
import net.thenextlvl.protect.area.Area;
import net.thenextlvl.protect.area.AreaCreator;
import net.thenextlvl.protect.area.AreaProvider;
import net.thenextlvl.protect.area.AreaService;
import net.thenextlvl.protect.area.CraftAreaProvider;
import net.thenextlvl.protect.area.CraftAreaService;
import net.thenextlvl.protect.area.CraftCuboidArea;
import net.thenextlvl.protect.area.CraftCylinderArea;
import net.thenextlvl.protect.area.CraftEllipsoidArea;
import net.thenextlvl.protect.area.CraftGlobalArea;
import net.thenextlvl.protect.area.CraftGroupedArea;
import net.thenextlvl.protect.bstats.bukkit.Metrics;
import net.thenextlvl.protect.commands.AreaCommand;
import net.thenextlvl.protect.controllers.CollisionController;
import net.thenextlvl.protect.flag.CraftFlagRegistry;
import net.thenextlvl.protect.flag.Flag;
import net.thenextlvl.protect.flag.FlagRegistry;
import net.thenextlvl.protect.flag.ProtectionFlag;
import net.thenextlvl.protect.listeners.AreaListener;
import net.thenextlvl.protect.listeners.ConnectionListener;
import net.thenextlvl.protect.listeners.EntityListener;
import net.thenextlvl.protect.listeners.MovementListener;
import net.thenextlvl.protect.listeners.NexoListener;
import net.thenextlvl.protect.listeners.PhysicsListener;
import net.thenextlvl.protect.listeners.WorldListener;
import net.thenextlvl.protect.masks.ProtectMaskManager;
import net.thenextlvl.protect.region.GroupedRegion;
import net.thenextlvl.protect.service.CraftProtectionService;
import net.thenextlvl.protect.service.ProtectionService;
import net.thenextlvl.protect.utils.MessageMigrator;
import net.thenextlvl.protect.version.PluginVersionChecker;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class ProtectPlugin
extends JavaPlugin {
    public static final String ISSUES = "https://github.com/TheNextLvl-net/protect/issues/new?template=bug_report.yml";
    public static final ErrorTracker ERROR_TRACKER = ErrorTracker.contextAware();
    private final Metrics metrics = new Metrics((Plugin)this, 21712);
    private final dev.faststats.core.Metrics fastStats = BukkitMetrics.factory().token("702e90699ba58f71536c54256557454e").errorTracker(ERROR_TRACKER).create((Plugin)this);
    private final Path schematicFolder = this.getDataPath().resolve("schematics");
    private final PluginVersionChecker versionChecker = new PluginVersionChecker((Plugin)this);
    private final CollisionController collisionController = new CollisionController();
    private final CraftProtectionService protectionService = new CraftProtectionService(this);
    private final CraftFlagRegistry flagRegistry = new CraftFlagRegistry();
    private final CraftAreaProvider areaProvider = new CraftAreaProvider(this);
    private final CraftAreaService areaService = new CraftAreaService(this);
    public final Flags flags = new Flags();
    private final Key key = Key.key((String)"protect", (String)"translations");
    private final Path translations = this.getDataPath().resolve("translations");
    private final ComponentBundle bundle = ComponentBundle.builder(this.key, this.translations).migrator(new MessageMigrator()).placeholder("failed_prefix", "prefix.failed").placeholder("prefix", "prefix").resource("protect.properties", Locale.US).resource("protect_german.properties", Locale.GERMANY).build();
    private final Cache<Audience, String> cooldown = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.SECONDS).build();
    public final NBT nbt = NBT.builder().registerTypeAdapter(new TypeToken<Map<Flag<?>, Object>>(){}.getType(), new FlagsAdapter(this)).registerTypeAdapter(new TypeToken<Set<UUID>>(){}.getType(), new MembersAdapter()).registerTypeHierarchyAdapter((Class<?>)Location.class, new LocationAdapter()).registerTypeHierarchyAdapter((Class<?>)Key.class, new KeyAdapter()).registerTypeHierarchyAdapter((Class<?>)WeatherType.class, new WeatherTypeAdapter()).registerTypeHierarchyAdapter((Class<?>)World.class, new WorldAdapter(this.getServer())).registerTypeHierarchyAdapter((Class<?>)CuboidRegion.class, new CuboidRegionAdapter()).registerTypeHierarchyAdapter((Class<?>)CylinderRegion.class, new CylinderRegionAdapter()).registerTypeHierarchyAdapter((Class<?>)EllipsoidRegion.class, new EllipsoidRegionAdapter()).registerTypeHierarchyAdapter((Class<?>)GroupedRegion.class, new GroupedRegionAdapter()).registerTypeHierarchyAdapter((Class<?>)BlockVector3.class, new BlockVectorAdapter()).registerTypeHierarchyAdapter((Class<?>)Vector2.class, new Vector2Adapter()).registerTypeHierarchyAdapter((Class<?>)Vector3.class, new Vector3Adapter()).build();

    public void onLoad() {
        WEManager.weManager().addManager((FaweMaskManager)new ProtectMaskManager(this));
        this.versionChecker.checkVersion();
        this.registerAdapters();
        this.registerServices();
        this.registerWrappers();
    }

    public void onEnable() {
        this.registerEvents();
        this.registerCommands();
    }

    public void onDisable() {
        this.getServer().getOnlinePlayers().forEach(this.collisionController::remove);
        this.getServer().getWorlds().forEach(world -> {
            this.areaProvider().save((World)world);
            this.areaProvider().unload((World)world);
        });
        this.metrics.shutdown();
    }

    private void registerServices() {
        this.getServer().getServicesManager().register(ProtectionService.class, (Object)this.protectionService(), (Plugin)this, ServicePriority.Highest);
        this.getServer().getServicesManager().register(FlagRegistry.class, (Object)this.flagRegistry(), (Plugin)this, ServicePriority.Highest);
        this.getServer().getServicesManager().register(AreaProvider.class, (Object)this.areaProvider(), (Plugin)this, ServicePriority.Highest);
        this.getServer().getServicesManager().register(AreaService.class, (Object)this.areaService(), (Plugin)this, ServicePriority.Highest);
    }

    private void registerAdapters() {
        this.areaService().registerAdapter(CraftCuboidArea.class, new CuboidAreaAdapter(this));
        this.areaService().registerAdapter(CraftCylinderArea.class, new CylinderAreaAdapter(this));
        this.areaService().registerAdapter(CraftEllipsoidArea.class, new EllipsoidAreaAdapter(this));
        this.areaService().registerAdapter(CraftGlobalArea.class, new GlobalAreaAdapter(this));
        this.areaService().registerAdapter(CraftGroupedArea.class, new GroupedAreaAdapter(this));
    }

    private void registerWrappers() {
        this.areaService().registerWrapper(CuboidRegion.class, creator -> new CraftCuboidArea(this, (AreaCreator<CuboidRegion>)creator));
        this.areaService().registerWrapper(CylinderRegion.class, creator -> new CraftCylinderArea(this, (AreaCreator<CylinderRegion>)creator));
        this.areaService().registerWrapper(EllipsoidRegion.class, creator -> new CraftEllipsoidArea(this, (AreaCreator<EllipsoidRegion>)creator));
        this.areaService().registerWrapper(GroupedRegion.class, creator -> new CraftGroupedArea(this, (AreaCreator<GroupedRegion>)creator));
    }

    private void registerEvents() {
        this.getServer().getPluginManager().registerEvents((Listener)new AreaListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ConnectionListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EntityListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new MovementListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PhysicsListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new WorldListener(this), (Plugin)this);
        Plugin nexo = this.getServer().getPluginManager().getPlugin("Nexo");
        if (nexo != null) {
            this.registerNexoEvents(nexo);
        }
    }

    private void registerNexoEvents(Plugin nexo) {
        this.getServer().getPluginManager().registerEvents((Listener)new NexoListener(this, nexo), (Plugin)this);
    }

    private void registerCommands() {
        this.getLifecycleManager().registerEventHandler(LifecycleEvents.COMMANDS.newHandler(event -> ((Commands)event.registrar()).register(AreaCommand.create(this))));
    }

    public void failed(@Nullable Audience audience, Area area, String message) {
        if (audience == null || !area.getFlag(this.flags.notifyFailedInteractions).booleanValue()) {
            return;
        }
        if (message.equals(this.cooldown.getIfPresent((Object)audience))) {
            return;
        }
        this.bundle().sendMessage(audience, message, new TagResolver[]{Placeholder.parsed((String)"area", (String)area.getName())});
        this.cooldown.put((Object)audience, (Object)message);
    }

    public void failed(@Nullable Audience audience, Cancellable cancellable, Area area, String message) {
        if (cancellable.isCancelled()) {
            this.failed(audience, area, message);
        }
    }

    public Path schematicFolder() {
        return this.schematicFolder;
    }

    public CollisionController collisionController() {
        return this.collisionController;
    }

    public CraftProtectionService protectionService() {
        return this.protectionService;
    }

    public CraftFlagRegistry flagRegistry() {
        return this.flagRegistry;
    }

    public CraftAreaProvider areaProvider() {
        return this.areaProvider;
    }

    public CraftAreaService areaService() {
        return this.areaService;
    }

    public ComponentBundle bundle() {
        return this.bundle;
    }

    public class Flags {
        public final Flag<@Nullable Long> time;
        public final Flag<@Nullable String> farewell;
        public final Flag<@Nullable String> farewellActionbar;
        public final Flag<@Nullable String> farewellTitle;
        public final Flag<@Nullable String> greetings;
        public final Flag<@Nullable String> greetingsActionbar;
        public final Flag<@Nullable String> greetingsTitle;
        public final Flag<@Nullable WeatherType> weather;
        public final Flag<Boolean> areaEnter;
        public final Flag<Boolean> areaLeave;
        public final Flag<Boolean> damage;
        public final Flag<Boolean> entityItemDrop;
        public final Flag<Boolean> entityItemPickup;
        public final Flag<Boolean> gameEvents;
        public final Flag<Boolean> gravity;
        public final Flag<Boolean> hunger;
        public final Flag<Boolean> liquidFlow;
        public final Flag<Boolean> naturalEntitySpawn;
        public final Flag<Boolean> notifyFailedInteractions;
        public final Flag<Boolean> physics;
        public final Flag<Boolean> redstone;
        public final Flag<Boolean> shoot;
        public final ProtectionFlag<Boolean> armorStandManipulate;
        public final ProtectionFlag<Boolean> blockAbsorb;
        public final ProtectionFlag<Boolean> blockBurning;
        public final ProtectionFlag<Boolean> blockDrying;
        public final ProtectionFlag<Boolean> blockFading;
        public final ProtectionFlag<Boolean> blockFertilize;
        public final ProtectionFlag<Boolean> blockForming;
        public final ProtectionFlag<Boolean> blockGrowth;
        public final ProtectionFlag<Boolean> blockIgniting;
        public final ProtectionFlag<Boolean> blockMoisturising;
        public final ProtectionFlag<Boolean> blockSpread;
        public final ProtectionFlag<Boolean> cauldronEvaporation;
        public final ProtectionFlag<Boolean> cauldronExtinguishEntity;
        public final ProtectionFlag<Boolean> collisions;
        public final ProtectionFlag<Boolean> cropTrample;
        public final ProtectionFlag<Boolean> destroy;
        public final ProtectionFlag<Boolean> entityAttackEntity;
        public final ProtectionFlag<Boolean> entityAttackPlayer;
        public final ProtectionFlag<Boolean> entityBreakDoor;
        public final ProtectionFlag<Boolean> entityInteract;
        public final ProtectionFlag<Boolean> entityShear;
        public final ProtectionFlag<Boolean> explosions;
        public final ProtectionFlag<Boolean> interact;
        public final ProtectionFlag<Boolean> leavesDecay;
        public final ProtectionFlag<Boolean> naturalCauldronFill;
        public final ProtectionFlag<Boolean> physicalInteract;
        public final ProtectionFlag<Boolean> place;
        public final ProtectionFlag<Boolean> playerAttackEntity;
        public final ProtectionFlag<Boolean> playerAttackPlayer;
        public final ProtectionFlag<Boolean> playerItemDrop;
        public final ProtectionFlag<Boolean> sheepEatGrass;

        public Flags() {
            this.time = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, Long.class, "time", null);
            this.farewell = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, String.class, "farewell", null);
            this.farewellActionbar = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, String.class, "farewell_actionbar", null);
            this.farewellTitle = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, String.class, "farewell_title", null);
            this.greetings = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, String.class, "greetings", null);
            this.greetingsActionbar = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, String.class, "greetings_actionbar", null);
            this.greetingsTitle = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, String.class, "greetings_title", null);
            this.weather = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, WeatherType.class, "weather", null);
            this.areaEnter = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "enter", true);
            this.areaLeave = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "leave", true);
            this.damage = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "damage", true);
            this.entityItemDrop = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "entity_item_drop", true);
            this.entityItemPickup = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "entity_item_pickup", true);
            this.gameEvents = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "game_events", true);
            this.gravity = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "gravity", true);
            this.hunger = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "hunger", true);
            this.liquidFlow = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "liquid_flow", true);
            this.naturalEntitySpawn = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "natural_entity_spawn", true);
            this.notifyFailedInteractions = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "notify_failed_interactions", false);
            this.physics = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "physics", true);
            this.redstone = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "redstone", true);
            this.shoot = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "shoot", true);
            this.armorStandManipulate = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "armor_stand_manipulate", true, Boolean.valueOf(false));
            this.blockAbsorb = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "block_absorb", true, Boolean.valueOf(false));
            this.blockBurning = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "block_burning", true, Boolean.valueOf(false));
            this.blockDrying = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "block_drying", true, Boolean.valueOf(false));
            this.blockFading = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "block_fading", true, Boolean.valueOf(false));
            this.blockFertilize = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "block_fertilize", true, Boolean.valueOf(false));
            this.blockForming = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "block_forming", true, Boolean.valueOf(false));
            this.blockGrowth = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "block_growth", true, Boolean.valueOf(false));
            this.blockIgniting = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "block_igniting", true, Boolean.valueOf(false));
            this.blockMoisturising = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "block_moisturising", true, Boolean.valueOf(false));
            this.blockSpread = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "block_spread", true, Boolean.valueOf(false));
            this.cauldronEvaporation = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "cauldron_evaporation", true, Boolean.valueOf(false));
            this.cauldronExtinguishEntity = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "cauldron_extinguish_entity", true, Boolean.valueOf(false));
            this.collisions = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "collisions", true, Boolean.valueOf(false));
            this.cropTrample = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "crop_trample", true, Boolean.valueOf(false));
            this.destroy = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "destroy", true, Boolean.valueOf(false));
            this.entityAttackEntity = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "entity_attack_entity", true, Boolean.valueOf(false));
            this.entityAttackPlayer = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "entity_attack_player", true, Boolean.valueOf(false));
            this.entityBreakDoor = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "entity_break_door", true, Boolean.valueOf(false));
            this.entityInteract = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "entity_interact", true, Boolean.valueOf(false));
            this.entityShear = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "entity_shear", true, Boolean.valueOf(false));
            this.explosions = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "explosions", true, Boolean.valueOf(false));
            this.interact = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "interact", true, Boolean.valueOf(false));
            this.leavesDecay = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "leaves_decay", true, Boolean.valueOf(false));
            this.naturalCauldronFill = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "natural_cauldron_fill", true, Boolean.valueOf(false));
            this.physicalInteract = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "physical_interact", true, Boolean.valueOf(false));
            this.place = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "place", true, Boolean.valueOf(false));
            this.playerAttackEntity = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "player_attack_entity", true, Boolean.valueOf(false));
            this.playerAttackPlayer = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "player_attack_player", true, Boolean.valueOf(false));
            this.playerItemDrop = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "player_item_drop", true, Boolean.valueOf(false));
            this.sheepEatGrass = ProtectPlugin.this.flagRegistry().register((Plugin)ProtectPlugin.this, "sheep_eat_grass", true, Boolean.valueOf(false));
        }
    }
}

