/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.protect.service;

import net.thenextlvl.protect.ProtectPlugin;
import net.thenextlvl.protect.area.Area;
import net.thenextlvl.protect.flag.Flag;
import net.thenextlvl.protect.flag.ProtectionFlag;
import net.thenextlvl.protect.service.ProtectionService;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class CraftProtectionService
implements ProtectionService {
    private final ProtectPlugin plugin;

    public CraftProtectionService(ProtectPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean canEdit(@Nullable Entity entity, Area area) {
        return this.canPlace(entity, area) && this.canDestroy(entity, area);
    }

    @Override
    public boolean canEdit(@Nullable Entity entity, Location location) {
        return this.canEdit(entity, this.plugin.areaProvider().getArea(location));
    }

    @Override
    public boolean canPlace(@Nullable Entity entity, Area area) {
        return this.canPerformAction(entity, area, this.plugin.flags.place, "protect.bypass.place");
    }

    @Override
    public boolean canPlace(@Nullable Entity entity, Location location) {
        return this.canPlace(entity, this.plugin.areaProvider().getArea(location));
    }

    @Override
    public boolean canDestroy(@Nullable Entity entity, Area area) {
        return this.canPerformAction(entity, area, this.plugin.flags.destroy, "protect.bypass.destroy");
    }

    @Override
    public boolean canDestroy(@Nullable Entity entity, Location location) {
        return this.canDestroy(entity, this.plugin.areaProvider().getArea(location));
    }

    @Override
    public boolean canInteract(@Nullable Entity entity, Location location) {
        return this.canPerformAction(entity, this.plugin.areaProvider().getArea(location), this.plugin.flags.interact, "protect.bypass.interact");
    }

    @Override
    public boolean canInteract(@Nullable Entity entity, Entity interacted) {
        ProtectionFlag<Boolean> flag = interacted.getType().equals((Object)EntityType.ARMOR_STAND) ? this.plugin.flags.armorStandManipulate : this.plugin.flags.entityInteract;
        return this.canPerformAction(entity, this.plugin.areaProvider().getArea(interacted), flag, "protect.bypass.entity-interact");
    }

    @Override
    public boolean canInteractPhysical(@Nullable Entity entity, Location location) {
        return this.canPerformAction(entity, this.plugin.areaProvider().getArea(location), this.plugin.flags.physicalInteract, "protect.bypass.physical-interact");
    }

    @Override
    public boolean canAttack(Entity attacker, Entity victim) {
        Player player;
        ProtectionFlag<Boolean> flag = attacker.getType().equals((Object)EntityType.PLAYER) && victim.getType().equals((Object)EntityType.PLAYER) ? this.plugin.flags.playerAttackPlayer : (attacker.getType().equals((Object)EntityType.PLAYER) ? this.plugin.flags.playerAttackEntity : (victim.getType().equals((Object)EntityType.PLAYER) ? this.plugin.flags.entityAttackPlayer : this.plugin.flags.entityAttackEntity));
        Area first = this.plugin.areaProvider().getArea(attacker);
        Area second = this.plugin.areaProvider().getArea(victim);
        if ((first.getFlag(flag).booleanValue() || first.isPermitted(attacker.getUniqueId())) && (second.getFlag(flag).booleanValue() || second.isPermitted(attacker.getUniqueId()))) {
            return true;
        }
        if (first.canInteract(second) && (first.getFlag(flag).booleanValue() || first.isPermitted(attacker.getUniqueId())) || second.getFlag(flag).booleanValue() || second.isPermitted(attacker.getUniqueId())) {
            return true;
        }
        if (!attacker.hasPermission("protect.bypass.attack")) {
            return false;
        }
        return attacker instanceof Player && (player = (Player)attacker).getGameMode().isInvulnerable();
    }

    @Override
    public boolean canShear(@Nullable Entity entity, Entity sheared) {
        return this.canPerformAction(entity, this.plugin.areaProvider().getArea(sheared), this.plugin.flags.entityShear, "protect.bypass.entity-shear");
    }

    @Override
    public boolean canTrample(@Nullable Entity entity, Location location) {
        return this.canPerformAction(entity, this.plugin.areaProvider().getArea(location), this.plugin.flags.cropTrample, "protect.bypass.trample");
    }

    @Override
    public boolean canEnter(@Nullable Entity entity, Area area) {
        return this.canPerformAction(entity, area, this.plugin.flags.areaEnter, "protect.bypass.enter");
    }

    @Override
    public boolean canLeave(@Nullable Entity entity, Area area) {
        return this.canPerformAction(entity, area, this.plugin.flags.areaLeave, "protect.bypass.leave");
    }

    @Override
    public boolean canPerformAction(@Nullable Entity entity, Area area, Flag<Boolean> flag, @Nullable String permission) {
        Player player;
        return area.getFlag(flag) != false || entity != null && (area.isPermitted(entity.getUniqueId()) || permission != null && entity.hasPermission(permission) && (!(entity instanceof Player) || (player = (Player)entity).getGameMode().isInvulnerable()));
    }
}

