/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.protect.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.PlayerSelectorArgumentResolver;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.protect.ProtectPlugin;
import net.thenextlvl.protect.area.Area;
import net.thenextlvl.protect.commands.argument.AreaArgumentType;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class AreaMembersCommand {
    AreaMembersCommand() {
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(ProtectPlugin plugin) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"members").requires(stack -> stack.getSender().hasPermission("protect.command.area.members"))).then(((LiteralArgumentBuilder)Commands.literal((String)"add").requires(stack -> stack.getSender().hasPermission("protect.command.area.members.add"))).then(Commands.argument((String)"area", (ArgumentType)new AreaArgumentType(plugin)).then(Commands.argument((String)"players", (ArgumentType)ArgumentTypes.players()).executes(context -> AreaMembersCommand.add((CommandContext<CommandSourceStack>)context, plugin)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"list").requires(stack -> stack.getSender().hasPermission("protect.command.area.members.list"))).then(Commands.argument((String)"area", (ArgumentType)new AreaArgumentType(plugin)).executes(context -> {
            Area area = (Area)context.getArgument("area", Area.class);
            return AreaMembersCommand.list((CommandContext<CommandSourceStack>)context, area, plugin);
        }))).executes(context -> {
            Area area = plugin.areaProvider().getArea(((CommandSourceStack)context.getSource()).getLocation());
            return AreaMembersCommand.list((CommandContext<CommandSourceStack>)context, area, plugin);
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"remove").requires(stack -> stack.getSender().hasPermission("protect.command.area.members.remove"))).then(Commands.argument((String)"area", (ArgumentType)new AreaArgumentType(plugin, (commandContext, area) -> !area.getMembers().isEmpty())).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            Area area = (Area)context.getLastChild().getArgument("area", Area.class);
            return CompletableFuture.runAsync(() -> area.getMembers().stream().map(arg_0 -> ((Server)plugin.getServer()).getOfflinePlayer(arg_0)).map(OfflinePlayer::getName).filter(Objects::nonNull).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0))).thenApply(unused -> builder.build());
        }).executes(context -> AreaMembersCommand.remove((CommandContext<CommandSourceStack>)context, plugin)))));
    }

    private static int list(CommandContext<CommandSourceStack> context, Area area, ProtectPlugin plugin) {
        plugin.getServer().getAsyncScheduler().runNow((Plugin)plugin, task -> {
            CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
            List<TextComponent> members = area.getMembers().stream().map(arg_0 -> ((Server)plugin.getServer()).getOfflinePlayer(arg_0)).map(OfflinePlayer::getName).filter(Objects::nonNull).map(Component::text).toList();
            String message = members.isEmpty() ? "area.members.none" : "area.members";
            plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{Placeholder.parsed((String)"area", (String)area.getName()), Formatter.number((String)"amount", (Number)members.size()), Formatter.joining((String)"members", members)});
        });
        return 1;
    }

    private static int add(CommandContext<CommandSourceStack> context, ProtectPlugin plugin) throws CommandSyntaxException {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        Area area = (Area)context.getArgument("area", Area.class);
        PlayerSelectorArgumentResolver resolver = (PlayerSelectorArgumentResolver)context.getArgument("players", PlayerSelectorArgumentResolver.class);
        List resolve = (List)resolver.resolve((CommandSourceStack)context.getSource());
        List<Player> added = resolve.stream().filter(player -> area.addMember(player.getUniqueId())).toList();
        if (added.isEmpty()) {
            plugin.bundle().sendMessage((Audience)sender, "nothing.changed");
        } else {
            added.forEach(player -> plugin.bundle().sendMessage((Audience)sender, "area.members.add", new TagResolver[]{Placeholder.component((String)"player", (ComponentLike)player.name().hoverEvent((HoverEventSource)player.asHoverEvent())), Placeholder.parsed((String)"area", (String)area.getName())}));
        }
        return added.size();
    }

    private static int remove(CommandContext<CommandSourceStack> context, ProtectPlugin plugin) {
        plugin.getServer().getAsyncScheduler().runNow((Plugin)plugin, task -> {
            CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
            Area area = (Area)context.getArgument("area", Area.class);
            String name = (String)context.getArgument("player", String.class);
            OfflinePlayer player = plugin.getServer().getOfflinePlayer(name);
            boolean success = area.removeMember(player.getUniqueId());
            String message = success ? "area.members.remove" : "nothing.changed";
            plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{Placeholder.parsed((String)"area", (String)area.getName()), Placeholder.parsed((String)"player", (String)(player.getName() != null ? player.getName() : name))});
        });
        return 1;
    }
}

