/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.protect.area;

import java.io.EOFException;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.kyori.adventure.key.Key;
import net.thenextlvl.nbt.NBTInputStream;
import net.thenextlvl.nbt.NBTOutputStream;
import net.thenextlvl.nbt.tag.CompoundTag;
import net.thenextlvl.nbt.tag.Tag;
import net.thenextlvl.protect.ProtectPlugin;
import net.thenextlvl.protect.area.Area;
import net.thenextlvl.protect.area.AreaProvider;
import net.thenextlvl.protect.area.CraftGlobalArea;
import net.thenextlvl.protect.area.GlobalArea;
import net.thenextlvl.protect.area.event.AreaLoadEvent;
import org.bukkit.Location;
import org.bukkit.World;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class CraftAreaProvider
implements AreaProvider {
    private final Map<World, Set<Area>> areas = new HashMap<World, Set<Area>>();
    private final ProtectPlugin plugin;

    public CraftAreaProvider(ProtectPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public Stream<Area> getAreas() {
        return this.areas.values().stream().flatMap(Collection::stream);
    }

    @Override
    public Stream<Area> getAreas(World world) {
        Set<Area> areas = this.areas.get(world);
        return areas != null ? areas.stream() : Stream.empty();
    }

    @Override
    public Stream<Area> getAreas(Location location) {
        return this.getAreas(location.getWorld()).filter(area -> area.contains(location));
    }

    @Override
    public Area getArea(Location location) {
        return this.getAreas(location).max(Comparator.comparingInt(Area::getPriority)).orElseGet(() -> this.getArea(location.getWorld()));
    }

    @Override
    public Optional<Area> getArea(String name) {
        return this.getAreas().filter(area -> area.getName().equals(name)).findAny();
    }

    @Override
    public GlobalArea getArea(World world) {
        return this.getAreas(world).filter(area -> area instanceof GlobalArea).map(area -> (GlobalArea)area).findAny().orElseThrow(() -> new IllegalStateException("No global area found for " + world.key().asString()));
    }

    public void load(World world) {
        Path areaFolder = world.getWorldFolder().toPath().resolve("areas");
        try (Stream<Path> files = Files.list(areaFolder).filter(path -> path.getFileName().toString().endsWith(".dat"));){
            files.forEach(file -> this.load(world, (Path)file));
            if (this.getAreas(world).anyMatch(area -> area instanceof GlobalArea)) {
                return;
            }
            this.persist(new CraftGlobalArea(this.plugin, world));
        }
        catch (Exception e) {
            this.plugin.getComponentLogger().error("Failed to load areas for {}", (Object)world.key().asString(), (Object)e);
            this.plugin.getComponentLogger().error("Please look for similar issues or report this on GitHub: {}", (Object)"https://github.com/TheNextLvl-net/protect/issues/new?template=bug_report.yml");
            ProtectPlugin.ERROR_TRACKER.trackError(e);
        }
    }

    private void load(World world, Path file) {
        try {
            Area loaded = this.read(world, null, file);
            new AreaLoadEvent(loaded).callEvent();
            this.memoize(world, loaded);
        }
        catch (EOFException e) {
            this.plugin.getComponentLogger().error("The area file {} is irrecoverably broken", (Object)file);
        }
        catch (Exception e) {
            this.plugin.getComponentLogger().error("Failed to load area from {}", (Object)file, (Object)e);
            this.plugin.getComponentLogger().error("Please look for similar issues or report this on GitHub: {}", (Object)"https://github.com/TheNextLvl-net/protect/issues/new?template=bug_report.yml");
            ProtectPlugin.ERROR_TRACKER.trackError(e);
        }
    }

    public void persist(Area area) throws IOException {
        this.memoize(area.getWorld(), this.read(area.getWorld(), area, area.getDataFile()));
    }

    private void memoize(World world, Area area) {
        Set areas = this.areas.computeIfAbsent(world, k -> new HashSet());
        areas.stream().filter((Predicate<Area>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Lnet/thenextlvl/protect/area/Area;)Z)((Area)area)).findAny().ifPresentOrElse(io -> this.plugin.getComponentLogger().warn("Ignoring duplicate area {}: {}", (Object)area.getName(), (Object)area.getDataFile()), () -> areas.add(area));
    }

    private Area read(World world, @Nullable Area area, Path file) throws IOException {
        if (area == null) {
            return this.read(file, world);
        }
        if (Files.isRegularFile(file, new LinkOption[0])) {
            return this.read(file, area);
        }
        this.save(area);
        return area;
    }

    private Area read(Path file, World world) throws IOException {
        Area area;
        block15: {
            NBTInputStream inputStream = NBTInputStream.create(file);
            try {
                area = this.read(world, inputStream);
                if (inputStream == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Path backup = file.resolveSibling(String.valueOf(file.getFileName()) + "_old");
                    if (!Files.isRegularFile(backup, new LinkOption[0])) {
                        throw e;
                    }
                    this.plugin.getComponentLogger().warn("Failed to load area from {}", (Object)file);
                    this.plugin.getComponentLogger().warn("Falling back to {}", (Object)backup);
                    try (NBTInputStream inputStream2 = NBTInputStream.create(backup);){
                        Area area2 = this.read(world, inputStream2);
                        return area2;
                    }
                }
            }
            inputStream.close();
        }
        return area;
    }

    private Area read(World world, NBTInputStream inputStream) throws IOException {
        Map.Entry<String, CompoundTag> entry = inputStream.readNamedTag();
        CompoundTag tag = entry.getValue();
        String name = entry.getKey();
        Key type = this.plugin.nbt.deserialize((Tag)tag.get("type"), Key.class);
        return this.plugin.areaService().getAdapter(type).construct(world, name, tag);
    }

    private Area read(Path file, Area area) throws IOException {
        try (NBTInputStream inputStream = NBTInputStream.create(file);){
            area.deserialize(inputStream.readTag());
            Area area2 = area;
            return area2;
        }
    }

    public void save(World world) {
        Set<Area> areas = this.areas.get(world);
        if (areas != null) {
            areas.forEach(this::save);
        }
    }

    private void save(Area area) {
        try {
            Path file = area.getDataFile();
            if (Files.isRegularFile(file, new LinkOption[0])) {
                Files.move(file, area.getBackupFile(), StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.createDirectories(file.toAbsolutePath().getParent(), new FileAttribute[0]);
            }
            try (NBTOutputStream outputStream = NBTOutputStream.create(file);){
                outputStream.writeTag(area.getName(), (Tag)area.serialize());
            }
        }
        catch (Exception e) {
            this.plugin.getComponentLogger().error("Failed to save area {}", (Object)area.getName(), (Object)e);
            this.plugin.getComponentLogger().error("Please look for similar issues or report this on GitHub: {}", (Object)"https://github.com/TheNextLvl-net/protect/issues/new?template=bug_report.yml");
            ProtectPlugin.ERROR_TRACKER.trackError(e);
        }
    }

    public void unload(World world) {
        this.areas.remove(world);
    }

    public boolean delete(Area area) {
        try {
            if (!(Files.deleteIfExists(area.getDataFile()) | Files.deleteIfExists(area.getBackupFile()))) {
                return false;
            }
            this.areas.computeIfPresent(area.getWorld(), (world, areas) -> {
                areas.remove(area);
                return areas.isEmpty() ? null : areas;
            });
            return true;
        }
        catch (IOException e) {
            this.plugin.getComponentLogger().warn("Failed to delete area {}", (Object)area.getName());
            this.plugin.getComponentLogger().warn("Please look for similar issues or report this on GitHub: {}", (Object)"https://github.com/TheNextLvl-net/protect/issues/new?template=bug_report.yml");
            ProtectPlugin.ERROR_TRACKER.trackError(e);
            return false;
        }
    }
}

